/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.DiscoveryClientUtils;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.ServiceMetadata;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortNameAndNumber;
import org.springframework.cloud.kubernetes.commons.discovery.ServicePortSecureResolver;
import org.springframework.cloud.kubernetes.fabric8.Fabric8Utils;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8DiscoveryServicesAdapter;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8InstanceIdHostPodNameSupplier;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8KubernetesDiscoveryClientUtils;
import org.springframework.cloud.kubernetes.fabric8.discovery.Fabric8PodLabelsAndAnnotationsSupplier;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesClientServicesFunction;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;

public class KubernetesDiscoveryClient
implements DiscoveryClient,
EnvironmentAware {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesDiscoveryClient.class));
    private final KubernetesDiscoveryProperties properties;
    private final KubernetesClientServicesFunction kubernetesClientServicesFunction;
    private final ServicePortSecureResolver servicePortSecureResolver;
    private final Fabric8DiscoveryServicesAdapter adapter;
    private KubernetesClient client;
    private KubernetesNamespaceProvider namespaceProvider;

    public KubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties kubernetesDiscoveryProperties, KubernetesClientServicesFunction kubernetesClientServicesFunction) {
        this(client, kubernetesDiscoveryProperties, kubernetesClientServicesFunction, null, new ServicePortSecureResolver(kubernetesDiscoveryProperties));
    }

    KubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties kubernetesDiscoveryProperties, KubernetesClientServicesFunction kubernetesClientServicesFunction, Predicate<Service> filter, ServicePortSecureResolver servicePortSecureResolver) {
        this.client = client;
        this.properties = kubernetesDiscoveryProperties;
        this.servicePortSecureResolver = servicePortSecureResolver;
        this.kubernetesClientServicesFunction = kubernetesClientServicesFunction;
        this.adapter = new Fabric8DiscoveryServicesAdapter(kubernetesClientServicesFunction, kubernetesDiscoveryProperties, filter);
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public void setClient(KubernetesClient client) {
        this.client = client;
    }

    public String description() {
        return "Fabric8 Kubernetes Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        Objects.requireNonNull(serviceId);
        List allEndpoints = this.getEndPointsList(serviceId).stream().toList();
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        for (Endpoints endpoints : allEndpoints) {
            instances.addAll(this.serviceInstances(endpoints, serviceId));
        }
        if (this.properties.includeExternalNameServices()) {
            LOG.debug(() -> "Searching for 'ExternalName' type of services with serviceId : " + serviceId);
            List<Service> services = Fabric8KubernetesDiscoveryClientUtils.services(this.properties, this.client, this.namespaceProvider, s -> s.getSpec().getType().equals("ExternalName"), Map.of("metadata.name", serviceId), "fabric8-discovery");
            for (Service service : services) {
                ServiceMetadata serviceMetadata = Fabric8Utils.serviceMetadata((Service)service);
                Map serviceInstanceMetadata = DiscoveryClientUtils.serviceInstanceMetadata(Map.of(), (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.properties);
                Fabric8InstanceIdHostPodNameSupplier supplierOne = Fabric8InstanceIdHostPodNameSupplier.externalName(service);
                Fabric8PodLabelsAndAnnotationsSupplier supplierTwo = Fabric8PodLabelsAndAnnotationsSupplier.externalName();
                ServiceInstance externalNameServiceInstance = DiscoveryClientUtils.serviceInstance(null, (ServiceMetadata)serviceMetadata, (Supplier)supplierOne, (Function)supplierTwo, (ServicePortNameAndNumber)new ServicePortNameAndNumber(-1, null), (Map)serviceInstanceMetadata, (KubernetesDiscoveryProperties)this.properties);
                instances.add(externalNameServiceInstance);
            }
        }
        return instances;
    }

    public List<Endpoints> getEndPointsList(String serviceId) {
        return Fabric8KubernetesDiscoveryClientUtils.endpoints(this.properties, this.client, this.namespaceProvider, "fabric8-discovery", serviceId, this.adapter.filter());
    }

    private List<ServiceInstance> serviceInstances(Endpoints endpoints, String serviceId) {
        List subsets = endpoints.getSubsets();
        if (subsets.isEmpty()) {
            LOG.debug(() -> "serviceId : " + serviceId + " does not have any subsets");
            return List.of();
        }
        String namespace = endpoints.getMetadata().getNamespace();
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceId)).get();
        ServiceMetadata serviceMetadata = Fabric8Utils.serviceMetadata((Service)service);
        Map<String, Integer> portsData = Fabric8KubernetesDiscoveryClientUtils.endpointSubsetsPortData(subsets);
        Map serviceInstanceMetadata = DiscoveryClientUtils.serviceInstanceMetadata(portsData, (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.properties);
        for (EndpointSubset endpointSubset : subsets) {
            Map<String, Integer> endpointsPortData = Fabric8KubernetesDiscoveryClientUtils.endpointSubsetsPortData(List.of(endpointSubset));
            ServicePortNameAndNumber portData = DiscoveryClientUtils.endpointsPort(endpointsPortData, (ServiceMetadata)serviceMetadata, (KubernetesDiscoveryProperties)this.properties);
            List<EndpointAddress> addresses = Fabric8KubernetesDiscoveryClientUtils.addresses(endpointSubset, this.properties);
            for (EndpointAddress endpointAddress : addresses) {
                Fabric8InstanceIdHostPodNameSupplier supplierOne = Fabric8InstanceIdHostPodNameSupplier.nonExternalName(endpointAddress, service);
                Fabric8PodLabelsAndAnnotationsSupplier supplierTwo = Fabric8PodLabelsAndAnnotationsSupplier.nonExternalName(this.client, namespace);
                ServiceInstance serviceInstance = DiscoveryClientUtils.serviceInstance((ServicePortSecureResolver)this.servicePortSecureResolver, (ServiceMetadata)serviceMetadata, (Supplier)supplierOne, (Function)supplierTwo, (ServicePortNameAndNumber)portData, (Map)serviceInstanceMetadata, (KubernetesDiscoveryProperties)this.properties);
                instances.add(serviceInstance);
            }
        }
        return instances;
    }

    public List<String> getServices() {
        List<String> services = this.adapter.apply(this.client).stream().map(s -> s.getMetadata().getName()).distinct().toList();
        LOG.debug(() -> "will return services : " + services);
        return services;
    }

    @Deprecated(forRemoval=true)
    public List<String> getServices(Predicate<Service> filter) {
        return new Fabric8DiscoveryServicesAdapter(this.kubernetesClientServicesFunction, this.properties, filter).apply(this.client).stream().map(s -> s.getMetadata().getName()).distinct().toList();
    }

    public int getOrder() {
        return this.properties.order();
    }

    @Deprecated(forRemoval=true)
    public final void setEnvironment(Environment environment) {
        this.namespaceProvider = new KubernetesNamespaceProvider(environment);
    }
}

