/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.loadbalancer;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesServiceInstanceMapper;
import org.springframework.cloud.kubernetes.commons.loadbalancer.KubernetesServicesListSupplier;
import org.springframework.cloud.kubernetes.fabric8.loadbalancer.Fabric8ServiceInstanceMapper;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class Fabric8ServicesListSupplier
extends KubernetesServicesListSupplier {
    private final KubernetesClient kubernetesClient;

    Fabric8ServicesListSupplier(Environment environment, KubernetesClient kubernetesClient, Fabric8ServiceInstanceMapper mapper, KubernetesDiscoveryProperties discoveryProperties) {
        super(environment, (KubernetesServiceInstanceMapper)mapper, discoveryProperties);
        this.kubernetesClient = kubernetesClient;
    }

    public Flux<List<ServiceInstance>> get() {
        ArrayList<KubernetesServiceInstance> result = new ArrayList<KubernetesServiceInstance>();
        if (this.discoveryProperties.allNamespaces()) {
            List services = ((ServiceList)((FilterWatchListDeletable)((AnyNamespaceOperation)this.kubernetesClient.services().inAnyNamespace()).withField("metadata.name", this.getServiceId())).list()).getItems();
            services.forEach(service -> result.add(this.mapper.map(service)));
        } else {
            Service service2;
            Service service3 = service2 = StringUtils.hasText((String)this.kubernetesClient.getNamespace()) ? (Service)((ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(this.kubernetesClient.getNamespace())).withName(this.getServiceId())).get() : (Service)((ServiceResource)this.kubernetesClient.services().withName(this.getServiceId())).get();
            if (service2 != null) {
                result.add(this.mapper.map((Object)service2));
            }
        }
        return Flux.defer(() -> Flux.just((Object)result));
    }
}

