/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.leader;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.kubernetes.leader.LeadershipController;

public class PodReadinessWatcher
implements Watcher<Pod> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PodReadinessWatcher.class);
    private final Object lock = new Object();
    private final String podName;
    private final KubernetesClient kubernetesClient;
    private final LeadershipController leadershipController;
    private boolean previousState;
    private Watch watch;

    public PodReadinessWatcher(String podName, KubernetesClient kubernetesClient, LeadershipController leadershipController) {
        this.podName = podName;
        this.kubernetesClient = kubernetesClient;
        this.leadershipController = leadershipController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.watch == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.watch == null) {
                    LOGGER.debug("Starting pod readiness watcher for '{}'", (Object)this.podName);
                    PodResource podResource = (PodResource)this.kubernetesClient.pods().withName(this.podName);
                    this.previousState = podResource.isReady();
                    this.watch = (Watch)podResource.watch((Object)this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.watch != null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.watch != null) {
                    LOGGER.debug("Stopping pod readiness watcher for '{}'", (Object)this.podName);
                    this.watch.close();
                    this.watch = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventReceived(Watcher.Action action, Pod pod) {
        boolean currentState = Readiness.isPodReady((Pod)pod);
        if (this.previousState != currentState) {
            Object object = this.lock;
            synchronized (object) {
                if (this.previousState != currentState) {
                    LOGGER.debug("'{}' readiness status changed to '{}', triggering leadership update", (Object)this.podName, (Object)currentState);
                    this.previousState = currentState;
                    this.leadershipController.update();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(KubernetesClientException cause) {
        if (cause != null) {
            Object object = this.lock;
            synchronized (object) {
                LOGGER.warn("Watcher stopped unexpectedly, will restart", (Throwable)cause);
                this.watch = null;
                this.start();
            }
        }
    }
}

