/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.kubernetes.ribbon.KubernetesConfigKey;
import org.springframework.cloud.kubernetes.ribbon.KubernetesRibbonProperties;

public abstract class KubernetesServerList
extends AbstractServerList<Server>
implements ServerList<Server> {
    private static final int FIRST = 0;
    private final KubernetesClient client;
    private String serviceId;
    private String namespace;
    private String portName;
    private KubernetesRibbonProperties properties;

    public KubernetesServerList(KubernetesClient client, KubernetesRibbonProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.serviceId = clientConfig.getClientName();
        this.namespace = clientConfig.getPropertyAsString(KubernetesConfigKey.Namespace, this.client.getNamespace());
        this.portName = clientConfig.getPropertyAsString(KubernetesConfigKey.PortName, null);
    }

    public List<Server> getInitialListOfServers() {
        return Collections.emptyList();
    }

    static int getFIRST() {
        return 0;
    }

    KubernetesClient getClient() {
        return this.client;
    }

    String getServiceId() {
        return this.serviceId;
    }

    String getNamespace() {
        return this.namespace;
    }

    String getPortName() {
        return this.portName;
    }

    KubernetesRibbonProperties getProperties() {
        return this.properties;
    }
}

