/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.support;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceSupplier;
import org.springframework.cloud.loadbalancer.support.SimpleObjectProvider;
import reactor.core.publisher.Flux;

public final class ServiceInstanceSuppliers {
    private ServiceInstanceSuppliers() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static ServiceInstanceSupplier from(final String serviceId, final ServiceInstance ... instances) {
        return new ServiceInstanceSupplier(){

            @Override
            public Flux<ServiceInstance> get() {
                return Flux.just((Object[])instances);
            }

            @Override
            public String getServiceId() {
                return serviceId;
            }
        };
    }

    public static ObjectProvider<ServiceInstanceSupplier> toProvider(String serviceId, ServiceInstance ... instances) {
        return new SimpleObjectProvider<ServiceInstanceSupplier>(ServiceInstanceSuppliers.from(serviceId, instances));
    }
}

