/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.cache.CacheFlux;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CachingServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    private static final Log log = LogFactory.getLog(CachingServiceInstanceListSupplier.class);
    public static final String SERVICE_INSTANCE_CACHE_NAME = CachingServiceInstanceListSupplier.class.getSimpleName() + "Cache";
    private final Flux<List<ServiceInstance>> serviceInstances;

    public CachingServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, CacheManager cacheManager) {
        super(delegate);
        this.serviceInstances = CacheFlux.lookup(key -> {
            Cache cache = cacheManager.getCache(SERVICE_INSTANCE_CACHE_NAME);
            if (cache == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Unable to find cache: " + SERVICE_INSTANCE_CACHE_NAME));
                }
                return Mono.empty();
            }
            List list = (List)cache.get(key, List.class);
            if (list == null || list.isEmpty()) {
                return Mono.empty();
            }
            return Flux.just((Object)list).materialize().collectList();
        }, (Object)delegate.getServiceId()).onCacheMissResume(((Flux)delegate.get()).take(1L)).andWriteWith((key, signals) -> Flux.fromIterable((Iterable)signals).dematerialize().doOnNext(instances -> {
            Cache cache = cacheManager.getCache(SERVICE_INSTANCE_CACHE_NAME);
            if (cache == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Unable to find cache for writing: " + SERVICE_INSTANCE_CACHE_NAME));
                }
            } else {
                cache.put(key, instances);
            }
        }).then());
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return this.serviceInstances;
    }
}

