/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RetryableRequestContext;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Flux;

public class RetryAwareServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    private final Log LOG = LogFactory.getLog(RetryAwareServiceInstanceListSupplier.class);

    public RetryAwareServiceInstanceListSupplier(ServiceInstanceListSupplier delegate) {
        super(delegate);
    }

    @Override
    public String getServiceId() {
        return this.delegate.getServiceId();
    }

    @Override
    public Flux<List<ServiceInstance>> get(Request request) {
        if (!(request.getContext() instanceof RetryableRequestContext)) {
            return this.delegate.get(request);
        }
        RetryableRequestContext context = (RetryableRequestContext)request.getContext();
        ServiceInstance previousServiceInstance = context.getPreviousServiceInstance();
        if (previousServiceInstance == null) {
            return this.delegate.get(request);
        }
        return this.delegate.get(request).map(instances -> this.filteredByPreviousInstance((List<ServiceInstance>)instances, previousServiceInstance));
    }

    private List<ServiceInstance> filteredByPreviousInstance(List<ServiceInstance> instances, ServiceInstance previousServiceInstance) {
        ArrayList<ServiceInstance> filteredInstances = new ArrayList<ServiceInstance>(instances);
        if (previousServiceInstance != null) {
            filteredInstances.remove(previousServiceInstance);
        }
        if (filteredInstances.size() > 0) {
            return filteredInstances;
        }
        if (this.LOG.isWarnEnabled()) {
            this.LOG.warn((Object)String.format("No instances found after removing previously used service instance from the search (%s). Returning all found instances.", previousServiceInstance));
        }
        return instances;
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return (Flux)this.delegate.get();
    }
}

