/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.eureka;

import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.ServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledNIWSServerList;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import com.netflix.niws.loadbalancer.NIWSDiscoveryPing;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.ribbon.RibbonProperyUtils;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.cloud.netflix.ribbon.eureka.DomainExtractingServerList;
import org.springframework.cloud.netflix.ribbon.eureka.EurekaServerIntrospector;
import org.springframework.cloud.netflix.ribbon.eureka.ZoneUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class EurekaRibbonClientConfiguration {
    private static final Log log = LogFactory.getLog(EurekaRibbonClientConfiguration.class);
    @Value(value="${ribbon.eureka.approximateZoneFromHostname:false}")
    private boolean approximateZoneFromHostname = false;
    @Value(value="${ribbon.client.name}")
    private String serviceId = "client";
    @Autowired(required=false)
    private EurekaClientConfig clientConfig;
    @Autowired(required=false)
    private EurekaInstanceConfig eurekaConfig;

    public EurekaRibbonClientConfiguration() {
    }

    public EurekaRibbonClientConfiguration(EurekaClientConfig clientConfig, String serviceId, EurekaInstanceConfig eurekaConfig, boolean approximateZoneFromHostname) {
        this.clientConfig = clientConfig;
        this.serviceId = serviceId;
        this.eurekaConfig = eurekaConfig;
        this.approximateZoneFromHostname = approximateZoneFromHostname;
    }

    @Bean
    @ConditionalOnMissingBean
    public IPing ribbonPing(IClientConfig config) {
        NIWSDiscoveryPing ping = new NIWSDiscoveryPing();
        ping.initWithNiwsConfig(config);
        return ping;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerList<?> ribbonServerList(IClientConfig config) {
        DiscoveryEnabledNIWSServerList discoveryServerList = new DiscoveryEnabledNIWSServerList(config);
        DomainExtractingServerList serverList = new DomainExtractingServerList((ServerList<DiscoveryEnabledServer>)discoveryServerList, config, this.approximateZoneFromHostname);
        return serverList;
    }

    @Bean
    public ServerIntrospector serverIntrospector() {
        return new EurekaServerIntrospector();
    }

    @PostConstruct
    public void preprocess() {
        String zone = ConfigurationManager.getDeploymentContext().getValue(DeploymentContext.ContextKey.zone);
        if (this.clientConfig != null && StringUtils.isEmpty((Object)zone)) {
            if (this.approximateZoneFromHostname && this.eurekaConfig != null) {
                String approxZone = ZoneUtils.extractApproximateZone(this.eurekaConfig.getHostName(false));
                log.debug((Object)("Setting Zone To " + approxZone));
                ConfigurationManager.getDeploymentContext().setValue(DeploymentContext.ContextKey.zone, approxZone);
            } else {
                String availabilityZone;
                String string = availabilityZone = this.eurekaConfig == null ? null : (String)this.eurekaConfig.getMetadataMap().get("zone");
                if (availabilityZone == null) {
                    String[] zones = this.clientConfig.getAvailabilityZones(this.clientConfig.getRegion());
                    String string2 = availabilityZone = zones != null && zones.length > 0 ? zones[0] : null;
                }
                if (availabilityZone != null) {
                    ConfigurationManager.getDeploymentContext().setValue(DeploymentContext.ContextKey.zone, availabilityZone);
                }
            }
        }
        RibbonProperyUtils.setRibbonProperty((String)this.serviceId, (String)CommonClientConfigKey.DeploymentContextBasedVipAddresses.key(), (String)this.serviceId);
        RibbonProperyUtils.setRibbonProperty((String)this.serviceId, (String)CommonClientConfigKey.EnableZoneAffinity.key(), (String)"true");
    }
}

