/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.ReflectionUtils;

public class CloudEurekaClient
extends DiscoveryClient {
    private static final Log log = LogFactory.getLog(CloudEurekaClient.class);
    private final AtomicLong cacheRefreshedCount = new AtomicLong(0L);
    private ApplicationEventPublisher publisher;
    private Field eurekaTransportField;
    private ApplicationInfoManager applicationInfoManager;
    private AtomicReference<EurekaHttpClient> eurekaHttpClient = new AtomicReference();

    public CloudEurekaClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, ApplicationEventPublisher publisher) {
        this(applicationInfoManager, config, null, publisher);
    }

    public CloudEurekaClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig config, DiscoveryClient.DiscoveryClientOptionalArgs args, ApplicationEventPublisher publisher) {
        super(applicationInfoManager, config, args);
        this.applicationInfoManager = applicationInfoManager;
        this.publisher = publisher;
        this.eurekaTransportField = ReflectionUtils.findField(DiscoveryClient.class, (String)"eurekaTransport");
        ReflectionUtils.makeAccessible((Field)this.eurekaTransportField);
    }

    public ApplicationInfoManager getApplicationInfoManager() {
        return this.applicationInfoManager;
    }

    public void cancelOverrideStatus(InstanceInfo info) {
        this.getEurekaHttpClient().deleteStatusOverride(info.getAppName(), info.getId(), info);
    }

    EurekaHttpClient getEurekaHttpClient() {
        if (this.eurekaHttpClient.get() == null) {
            try {
                Object eurekaTransport = this.eurekaTransportField.get((Object)this);
                Field registrationClientField = ReflectionUtils.findField(eurekaTransport.getClass(), (String)"registrationClient");
                ReflectionUtils.makeAccessible((Field)registrationClientField);
                this.eurekaHttpClient.compareAndSet(null, (EurekaHttpClient)registrationClientField.get(eurekaTransport));
            }
            catch (IllegalAccessException e) {
                log.error((Object)"error getting EurekaHttpClient", (Throwable)e);
            }
        }
        return this.eurekaHttpClient.get();
    }

    public void setStatus(InstanceInfo.InstanceStatus newStatus, InstanceInfo info) {
        this.getEurekaHttpClient().statusUpdate(info.getAppName(), info.getId(), newStatus, info);
    }

    protected void onCacheRefreshed() {
        if (this.cacheRefreshedCount != null) {
            long newCount = this.cacheRefreshedCount.incrementAndGet();
            log.trace((Object)("onCacheRefreshed called with count: " + newCount));
            this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)newCount));
        }
    }
}

