/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.loadbalancer;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientConfigurationRegistrar;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.cloud.netflix.eureka.loadbalancer.EurekaLoadBalancerClientConfiguration;
import org.springframework.cloud.netflix.eureka.loadbalancer.EurekaLoadBalancerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={EurekaLoadBalancerProperties.class})
@ConditionalOnClass(value={LoadBalancerClientConfigurationRegistrar.class})
@LoadBalancerClients(defaultConfiguration={EurekaLoadBalancerClientConfiguration.class})
public class LoadBalancerEurekaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    EurekaLoadBalancerProperties eurekaLoadBalancerProperties() {
        return new EurekaLoadBalancerProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="spring.cloud.loadbalancer")
    LoadBalancerProperties loadBalancerProperties() {
        return new LoadBalancerProperties();
    }
}

