/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.util.Timeout;
import org.springframework.cloud.netflix.eureka.RestTemplateTimeoutProperties;
import org.springframework.cloud.netflix.eureka.TimeoutProperties;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.lang.Nullable;

public class DefaultEurekaClientHttpRequestFactorySupplier
implements EurekaClientHttpRequestFactorySupplier {
    private final TimeoutProperties timeoutProperties;

    @Deprecated(forRemoval=true)
    public DefaultEurekaClientHttpRequestFactorySupplier() {
        this.timeoutProperties = new RestTemplateTimeoutProperties();
    }

    @Deprecated(forRemoval=true)
    public DefaultEurekaClientHttpRequestFactorySupplier(RestTemplateTimeoutProperties timeoutProperties) {
        this.timeoutProperties = timeoutProperties;
    }

    public DefaultEurekaClientHttpRequestFactorySupplier(TimeoutProperties timeoutProperties) {
        this.timeoutProperties = timeoutProperties;
    }

    @Override
    public ClientHttpRequestFactory get(SSLContext sslContext, @Nullable HostnameVerifier hostnameVerifier) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (sslContext != null || hostnameVerifier != null || this.timeoutProperties != null) {
            httpClientBuilder.setConnectionManager(this.buildConnectionManager(sslContext, hostnameVerifier, this.timeoutProperties));
        }
        if (this.timeoutProperties != null) {
            httpClientBuilder.setDefaultRequestConfig(this.buildRequestConfig());
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClient);
        return requestFactory;
    }

    private HttpClientConnectionManager buildConnectionManager(SSLContext sslContext, HostnameVerifier hostnameVerifier, TimeoutProperties restTemplateTimeoutProperties) {
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        SSLConnectionSocketFactoryBuilder sslConnectionSocketFactoryBuilder = SSLConnectionSocketFactoryBuilder.create();
        if (sslContext != null) {
            sslConnectionSocketFactoryBuilder.setSslContext(sslContext);
        }
        if (hostnameVerifier != null) {
            sslConnectionSocketFactoryBuilder.setHostnameVerifier(hostnameVerifier);
        }
        connectionManagerBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactoryBuilder.build());
        if (restTemplateTimeoutProperties != null) {
            connectionManagerBuilder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.of((long)restTemplateTimeoutProperties.getSocketTimeout(), (TimeUnit)TimeUnit.MILLISECONDS)).build());
        }
        return connectionManagerBuilder.build();
    }

    private RequestConfig buildRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(Timeout.of((long)this.timeoutProperties.getConnectTimeout(), (TimeUnit)TimeUnit.MILLISECONDS)).setConnectionRequestTimeout(Timeout.of((long)this.timeoutProperties.getConnectRequestTimeout(), (TimeUnit)TimeUnit.MILLISECONDS)).build();
    }
}

