/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.boot.health.contributor.CompositeHealthContributor;
import org.springframework.boot.health.contributor.CompositeReactiveHealthContributor;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.boot.health.contributor.HealthContributors;
import org.springframework.boot.health.contributor.HealthIndicator;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthContributors;
import org.springframework.boot.health.contributor.ReactiveHealthIndicator;
import org.springframework.boot.health.contributor.Status;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthContributor;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;
import org.springframework.cloud.netflix.eureka.EurekaHealthIndicator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class EurekaHealthCheckHandler
implements HealthCheckHandler,
ApplicationContextAware,
InitializingBean,
Ordered,
Lifecycle {
    private static final Map<Status, InstanceInfo.InstanceStatus> STATUS_MAPPING = new HashMap<Status, InstanceInfo.InstanceStatus>(){
        {
            this.put(Status.UNKNOWN, InstanceInfo.InstanceStatus.UNKNOWN);
            this.put(Status.OUT_OF_SERVICE, InstanceInfo.InstanceStatus.DOWN);
            this.put(Status.DOWN, InstanceInfo.InstanceStatus.DOWN);
            this.put(Status.UP, InstanceInfo.InstanceStatus.UP);
        }
    };
    private final StatusAggregator statusAggregator;
    private ApplicationContext applicationContext;
    private final Map<String, HealthContributor> healthContributors = new HashMap<String, HealthContributor>();
    private boolean running = true;
    private final Map<String, ReactiveHealthContributor> reactiveHealthContributors = new HashMap<String, ReactiveHealthContributor>();

    public EurekaHealthCheckHandler(StatusAggregator statusAggregator) {
        this.statusAggregator = statusAggregator;
        Assert.notNull((Object)statusAggregator, (String)"StatusAggregator must not be null");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        this.populateHealthContributors(this.applicationContext.getBeansOfType(HealthContributor.class));
        this.reactiveHealthContributors.putAll(this.applicationContext.getBeansOfType(ReactiveHealthContributor.class));
    }

    void populateHealthContributors(Map<String, HealthContributor> healthContributors) {
        for (Map.Entry<String, HealthContributor> entry : healthContributors.entrySet()) {
            HealthContributor healthContributor = entry.getValue();
            if (healthContributor instanceof DiscoveryCompositeHealthContributor) {
                DiscoveryCompositeHealthContributor indicator = (DiscoveryCompositeHealthContributor)healthContributor;
                indicator.getIndicators().forEach((name, discoveryHealthIndicator) -> {
                    if (!(discoveryHealthIndicator instanceof EurekaHealthIndicator)) {
                        this.healthContributors.put((String)name, (HealthContributor)((HealthIndicator)() -> ((DiscoveryHealthIndicator)discoveryHealthIndicator).health()));
                    }
                });
                continue;
            }
            this.healthContributors.put(entry.getKey(), entry.getValue());
        }
    }

    public InstanceInfo.InstanceStatus getStatus(InstanceInfo.InstanceStatus instanceStatus) {
        if (this.running) {
            return this.getHealthStatus();
        }
        return null;
    }

    protected InstanceInfo.InstanceStatus getHealthStatus() {
        Status status = this.getStatus(this.statusAggregator);
        return this.mapToInstanceStatus(status);
    }

    protected Status getStatus(StatusAggregator statusAggregator) {
        HashSet<Status> statusSet = new HashSet<Status>();
        for (HealthContributor healthContributor : this.healthContributors.values()) {
            this.processContributor(statusSet, healthContributor);
        }
        for (ReactiveHealthContributor reactiveHealthContributor : this.reactiveHealthContributors.values()) {
            this.processContributor(statusSet, reactiveHealthContributor);
        }
        return statusAggregator.getAggregateStatus(statusSet);
    }

    private void processContributor(Set<Status> statusSet, HealthContributor contributor) {
        if (contributor instanceof CompositeHealthContributor) {
            for (HealthContributors.Entry contrib : (CompositeHealthContributor)contributor) {
                this.processContributor(statusSet, contrib.contributor());
            }
        } else if (contributor instanceof HealthIndicator) {
            statusSet.add(((HealthIndicator)contributor).health().getStatus());
        }
    }

    private void processContributor(Set<Status> statusSet, ReactiveHealthContributor contributor) {
        Health health;
        if (contributor instanceof CompositeReactiveHealthContributor) {
            for (ReactiveHealthContributors.Entry contrib : (CompositeReactiveHealthContributor)contributor) {
                this.processContributor(statusSet, contrib.contributor());
            }
        } else if (contributor instanceof ReactiveHealthIndicator && (health = (Health)((ReactiveHealthIndicator)contributor).health().block()) != null) {
            statusSet.add(health.getStatus());
        }
    }

    protected InstanceInfo.InstanceStatus mapToInstanceStatus(Status status) {
        if (!STATUS_MAPPING.containsKey(status)) {
            return InstanceInfo.InstanceStatus.UNKNOWN;
        }
        return STATUS_MAPPING.get(status);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return true;
    }
}

