/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.config;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.netflix.eureka.EurekaServiceInstance;
import org.springframework.http.HttpStatus;

public class EurekaConfigServerInstanceProvider {
    private final Log log;
    private final EurekaHttpClient client;
    private final EurekaClientConfig config;

    public EurekaConfigServerInstanceProvider(EurekaHttpClient client, EurekaClientConfig config) {
        this(LogFactory.getLog(EurekaConfigServerInstanceProvider.class), client, config);
    }

    public EurekaConfigServerInstanceProvider(Log log, EurekaHttpClient client, EurekaClientConfig config) {
        this.log = log;
        this.client = client;
        this.config = config;
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        String remoteRegionsStr;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("eurekaConfigServerInstanceProvider finding instances for " + serviceId));
        }
        String[] remoteRegions = (remoteRegionsStr = this.config.fetchRegistryForRemoteRegions()) == null ? null : remoteRegionsStr.split(",");
        EurekaHttpResponse response = this.config.getRegistryRefreshSingleVipAddress() == null ? this.client.getApplications(remoteRegions) : this.client.getVip(this.config.getRegistryRefreshSingleVipAddress(), remoteRegions);
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        if (!this.isSuccessful((EurekaHttpResponse<Applications>)response) || response.getEntity() == null) {
            return instances;
        }
        Applications applications = (Applications)response.getEntity();
        applications.shuffleInstances(this.config.shouldFilterOnlyUpInstances());
        List infos = applications.getInstancesByVirtualHostName(serviceId);
        for (InstanceInfo info : infos) {
            instances.add(new EurekaServiceInstance(info));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("eurekaConfigServerInstanceProvider found " + infos.size() + " instance(s) for " + serviceId + ", " + String.valueOf(instances)));
        }
        return instances;
    }

    private boolean isSuccessful(EurekaHttpResponse<Applications> response) {
        HttpStatus httpStatus = HttpStatus.resolve((int)response.getStatusCode());
        return httpStatus != null && httpStatus.is2xxSuccessful();
    }
}

