/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import java.time.Duration;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.web.bind.annotation.GetMapping;
import reactor.core.publisher.Flux;

@RestControllerEndpoint(id="hystrix.stream")
public class HystrixWebfluxEndpoint {
    private final Flux<String> stream;

    public HystrixWebfluxEndpoint(Publisher<String> dashboardData) {
        this.stream = Flux.interval((Duration)Duration.ofMillis(500L)).map(aLong -> "{\"type\":\"ping\"}").mergeWith(dashboardData).share();
    }

    @GetMapping(path={""}, produces={"text/event-stream"})
    public Flux<String> hystrixStream() {
        return this.stream;
    }
}

