/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.sidecar;

import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.discovery.EurekaClientConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.sidecar.LocalApplicationHealthCheckHandler;
import org.springframework.cloud.netflix.sidecar.LocalApplicationHealthIndicator;
import org.springframework.cloud.netflix.sidecar.SidecarController;
import org.springframework.cloud.netflix.sidecar.SidecarProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConditionalOnProperty(value={"spring.cloud.netflix.sidecar.enabled"}, matchIfMissing=true)
public class SidecarConfiguration {
    @Bean
    public SidecarProperties sidecarProperties() {
        return new SidecarProperties();
    }

    @Bean
    public LocalApplicationHealthIndicator localApplicationHealthIndicator() {
        return new LocalApplicationHealthIndicator();
    }

    @Bean
    public SidecarController sidecarController() {
        return new SidecarController();
    }

    @Configuration
    @ConditionalOnClass(value={EurekaClientConfig.class})
    protected static class EurekaInstanceConfigBeanConfiguration {
        @Autowired
        private SidecarProperties sidecarProperties;
        @Value(value="${server.port:${SERVER_PORT:${PORT:8080}}}")
        private int serverPort = 8080;

        protected EurekaInstanceConfigBeanConfiguration() {
        }

        @Bean
        public EurekaInstanceConfigBean eurekaInstanceConfigBean() {
            EurekaInstanceConfigBean config = new EurekaInstanceConfigBean();
            int port = this.sidecarProperties.getPort();
            config.setNonSecurePort(port);
            String scheme = config.getSecurePortEnabled() ? "https" : "http";
            config.setStatusPageUrl(String.valueOf(scheme) + "://" + config.getHostname() + ":" + this.serverPort + config.getStatusPageUrlPath());
            config.setHealthCheckUrl(String.valueOf(scheme) + "://" + config.getHostname() + ":" + this.serverPort + config.getHealthCheckUrlPath());
            config.setHomePageUrl(String.valueOf(scheme) + "://" + config.getHostname() + ":" + port + config.getHomePageUrlPath());
            return config;
        }

        @Bean
        public HealthCheckHandler healthCheckHandler(LocalApplicationHealthIndicator healthIndicator) {
            return new LocalApplicationHealthCheckHandler((HealthIndicator)healthIndicator);
        }
    }
}

