/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.sidecar;

import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.discovery.EurekaClientConfig;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.commons.util.IdUtils;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.eureka.metadata.DefaultManagementMetadataProvider;
import org.springframework.cloud.netflix.eureka.metadata.ManagementMetadata;
import org.springframework.cloud.netflix.eureka.metadata.ManagementMetadataProvider;
import org.springframework.cloud.netflix.sidecar.LocalApplicationHealthCheckHandler;
import org.springframework.cloud.netflix.sidecar.LocalApplicationHealthIndicator;
import org.springframework.cloud.netflix.sidecar.SidecarController;
import org.springframework.cloud.netflix.sidecar.SidecarProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties
@ConditionalOnProperty(value={"spring.cloud.netflix.sidecar.enabled"}, matchIfMissing=true)
public class SidecarConfiguration {
    @Bean
    public HasFeatures Feature() {
        return HasFeatures.namedFeature((String)"Netflix Sidecar", SidecarConfiguration.class);
    }

    @Bean
    public SidecarProperties sidecarProperties() {
        return new SidecarProperties();
    }

    @Bean
    @ConditionalOnMissingClass(value={"org.apache.http.client.HttpClient"})
    public RestTemplate restTemplate() {
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]).build();
    }

    @Bean
    @ConditionalOnClass(value={HttpClient.class})
    public RestTemplate sslRestTemplate(SidecarProperties properties) {
        RestTemplateBuilder builder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        if (properties.acceptAllSslCertificates()) {
            CloseableHttpClient httpClient = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();
            HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
            requestFactory.setHttpClient((HttpClient)httpClient);
            builder = builder.requestFactory(() -> requestFactory);
        }
        return builder.build();
    }

    @Bean
    public LocalApplicationHealthIndicator localApplicationHealthIndicator() {
        return new LocalApplicationHealthIndicator();
    }

    @Bean
    public SidecarController sidecarController() {
        return new SidecarController();
    }

    @Configuration
    @ConditionalOnClass(value={EurekaClientConfig.class})
    protected static class EurekaInstanceConfigBeanConfiguration {
        @Autowired
        private SidecarProperties sidecarProperties;
        @Autowired
        private InetUtils inetUtils;
        @Value(value="${management.port:${MANAGEMENT_PORT:#{null}}}")
        private Integer managementPort;
        @Value(value="${server.port:${SERVER_PORT:${PORT:8080}}}")
        private int serverPort = 8080;
        @Value(value="${management.context-path:${MANAGEMENT_CONTEXT_PATH:#{null}}}")
        private String managementContextPath;
        @Value(value="${server.context-path:${SERVER_CONTEXT_PATH:/}}")
        private String serverContextPath = "/";
        @Value(value="${eureka.instance.hostname:${EUREKA_INSTANCE_HOSTNAME:}}")
        private String hostname;
        @Autowired
        private ConfigurableEnvironment env;

        protected EurekaInstanceConfigBeanConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ManagementMetadataProvider serviceManagementMetadataProvider() {
            return new DefaultManagementMetadataProvider();
        }

        @Bean
        public EurekaInstanceConfigBean eurekaInstanceConfigBean(ManagementMetadataProvider managementMetadataProvider) {
            EurekaInstanceConfigBean config = new EurekaInstanceConfigBean(this.inetUtils);
            String springAppName = this.env.getProperty("spring.application.name", "");
            int port = this.sidecarProperties.getPort();
            config.setNonSecurePort(port);
            config.setInstanceId(IdUtils.getDefaultInstanceId((PropertyResolver)this.env));
            if (StringUtils.hasText((String)springAppName)) {
                config.setAppname(springAppName);
                config.setVirtualHostName(springAppName);
                config.setSecureVirtualHostName(springAppName);
            }
            String hostname = this.sidecarProperties.getHostname();
            String ipAddress = this.sidecarProperties.getIpAddress();
            if (!StringUtils.hasText((String)hostname) && StringUtils.hasText((String)this.hostname)) {
                hostname = this.hostname;
            }
            if (StringUtils.hasText((String)hostname)) {
                config.setHostname(hostname);
            }
            if (StringUtils.hasText((String)ipAddress)) {
                config.setIpAddress(ipAddress);
            }
            String scheme = config.getSecurePortEnabled() ? "https" : "http";
            ManagementMetadata metadata = managementMetadataProvider.get(config, this.serverPort, this.serverContextPath, this.managementContextPath, this.managementPort);
            if (metadata != null) {
                Map metadataMap;
                config.setStatusPageUrl(metadata.getStatusPageUrl());
                config.setHealthCheckUrl(metadata.getHealthCheckUrl());
                if (config.isSecurePortEnabled()) {
                    config.setSecureHealthCheckUrl(metadata.getSecureHealthCheckUrl());
                }
                if ((metadataMap = config.getMetadataMap()).get("management.port") == null) {
                    metadataMap.put("management.port", String.valueOf(metadata.getManagementPort()));
                }
            }
            config.setHomePageUrl(scheme + "://" + config.getHostname() + ":" + port + config.getHomePageUrlPath());
            return config;
        }

        @Bean
        public HealthCheckHandler healthCheckHandler(LocalApplicationHealthIndicator healthIndicator) {
            return new LocalApplicationHealthCheckHandler((HealthIndicator)healthIndicator);
        }
    }
}

