/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import com.netflix.turbine.discovery.InstanceDiscovery;
import com.netflix.turbine.init.TurbineInit;
import com.netflix.turbine.monitor.cluster.ClusterMonitorFactory;
import com.netflix.turbine.plugins.PluginsFactory;
import com.netflix.turbine.streaming.servlet.TurbineStreamServlet;
import javax.servlet.Servlet;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.turbine.EurekaInstanceDiscovery;
import org.springframework.cloud.netflix.turbine.SpringAggregatorFactory;
import org.springframework.cloud.netflix.turbine.TurbineProperties;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

@Configuration
@EnableConfigurationProperties
@EnableDiscoveryClient
public class TurbineConfiguration
implements SmartLifecycle,
Ordered {
    private boolean running;

    @Bean
    public ServletRegistrationBean turbineStreamServlet() {
        return new ServletRegistrationBean((Servlet)new TurbineStreamServlet(), new String[]{"/turbine.stream"});
    }

    @Bean
    public TurbineProperties turbineProperties() {
        return new TurbineProperties();
    }

    @Bean
    public InstanceDiscovery instanceDiscovery() {
        return new EurekaInstanceDiscovery(this.turbineProperties());
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        callback.run();
    }

    public void start() {
        PluginsFactory.setClusterMonitorFactory((ClusterMonitorFactory)new SpringAggregatorFactory());
        PluginsFactory.setInstanceDiscovery((InstanceDiscovery)this.instanceDiscovery());
        TurbineInit.init();
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0;
    }

    public int getOrder() {
        return -1;
    }
}

