/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import com.netflix.turbine.discovery.Instance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.turbine.CommonsInstanceDiscovery;
import org.springframework.cloud.netflix.turbine.TurbineProperties;

public class EurekaInstanceDiscovery
extends CommonsInstanceDiscovery {
    private static final Log log = LogFactory.getLog(EurekaInstanceDiscovery.class);
    private static final String EUREKA_DEFAULT_CLUSTER_NAME_EXPRESSION = "appName";
    private static final String ASG_KEY = "asg";
    private final EurekaClient eurekaClient;

    public EurekaInstanceDiscovery(TurbineProperties turbineProperties, EurekaClient eurekaClient) {
        super(turbineProperties, EUREKA_DEFAULT_CLUSTER_NAME_EXPRESSION);
        this.eurekaClient = eurekaClient;
    }

    @Override
    protected List<Instance> getInstancesForApp(String serviceId) throws Exception {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        log.info((Object)("Fetching instances for app: " + serviceId));
        Application app = this.eurekaClient.getApplication(serviceId);
        if (app == null) {
            log.warn((Object)("Eureka returned null for app: " + serviceId));
            return instances;
        }
        try {
            List instancesForApp = app.getInstances();
            if (instancesForApp != null) {
                log.info((Object)("Received instance list for app: " + serviceId + ", size=" + instancesForApp.size()));
                for (InstanceInfo iInfo : instancesForApp) {
                    Instance instance = this.marshall(iInfo);
                    if (instance == null) continue;
                    instances.add(instance);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Failed to retrieve instances from Eureka", (Throwable)e);
        }
        return instances;
    }

    Instance marshall(InstanceInfo instanceInfo) {
        String hostname = instanceInfo.getHostName();
        String port = String.valueOf(instanceInfo.getPort());
        String cluster = this.getClusterName(instanceInfo);
        Boolean status = this.parseInstanceStatus(instanceInfo.getStatus());
        if (hostname != null && cluster != null && status != null) {
            DataCenterInfo dcInfo;
            Instance instance = this.getInstance(hostname, port, cluster, status);
            Map metadata = instanceInfo.getMetadata();
            boolean securePortEnabled = instanceInfo.isPortEnabled(InstanceInfo.PortType.SECURE);
            String securePort = String.valueOf(instanceInfo.getSecurePort());
            this.addMetadata(instance, hostname, port, securePortEnabled, securePort, metadata);
            String asgName = instanceInfo.getASGName();
            if (asgName != null) {
                instance.getAttributes().put(ASG_KEY, asgName);
            }
            if ((dcInfo = instanceInfo.getDataCenterInfo()) != null && dcInfo.getName().equals((Object)DataCenterInfo.Name.Amazon)) {
                AmazonInfo amznInfo = (AmazonInfo)dcInfo;
                instance.getAttributes().putAll(amznInfo.getMetadata());
            }
            return instance;
        }
        return null;
    }

    protected Boolean parseInstanceStatus(InstanceInfo.InstanceStatus status) {
        if (status == null) {
            return null;
        }
        return status == InstanceInfo.InstanceStatus.UP;
    }
}

