/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine;

import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.turbine.TurbineClustersProvider;

public class EurekaBasedTurbineClustersProvider
implements TurbineClustersProvider {
    private static final Log log = LogFactory.getLog(EurekaBasedTurbineClustersProvider.class);
    private final EurekaClient eurekaClient;

    public EurekaBasedTurbineClustersProvider(EurekaClient eurekaClient) {
        this.eurekaClient = eurekaClient;
    }

    @Override
    public List<String> getClusterNames() {
        Applications applications = this.eurekaClient.getApplications();
        List registeredApplications = applications.getRegisteredApplications();
        ArrayList<String> appNames = new ArrayList<String>(registeredApplications.size());
        for (Application application : registeredApplications) {
            appNames.add(application.getName());
        }
        log.trace((Object)("Using clusters names: " + appNames));
        return appNames;
    }
}

