/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MetadataUtils {
    private MetadataUtils() {
    }

    public static Map<String, Object> convertMap(Map<String, Object> parameters) {
        HashMap<String, Object> convertedMap = new HashMap<String, Object>(parameters.size());
        parameters.forEach((key, value) -> convertedMap.put((String)key, MetadataUtils.convertEntry(value)));
        return convertedMap;
    }

    private static Object convertEntry(Object value) {
        Object convertedValue;
        if (value instanceof Map) {
            Map valueMap = (Map)((Object)value);
            convertedValue = MetadataUtils.isNumberedMap(valueMap) ? MetadataUtils.convertNumberedMapToArray(valueMap) : MetadataUtils.convertMap(valueMap);
        } else if (value instanceof List) {
            List castedList = value;
            convertedValue = MetadataUtils.convertList(castedList);
        } else {
            convertedValue = value;
        }
        return convertedValue;
    }

    private static List<Object> convertNumberedMapToArray(Map<String, Object> map) {
        ArrayList<Object> list = new ArrayList<Object>(map.size());
        int i = 0;
        while (map.get(Integer.toString(i)) != null) {
            Map<String, Object> arrayItem = map.get(Integer.toString(i));
            if (arrayItem instanceof Map) {
                Map castedArrayItem = arrayItem;
                arrayItem = MetadataUtils.convertMap(castedArrayItem);
            }
            list.add(arrayItem);
            ++i;
        }
        return list;
    }

    private static List<Object> convertList(List<Object> value) {
        ArrayList<Object> convertedList = new ArrayList<Object>(value.size());
        value.forEach(item -> convertedList.add(MetadataUtils.convertEntry(item)));
        return convertedList;
    }

    private static boolean isNumberedMap(Map<String, Object> map) {
        int matchingKeyIndex = -1;
        int i = 0;
        while (map.get(Integer.toString(i)) != null) {
            matchingKeyIndex = i++;
        }
        boolean atLeastOneIntegerIndexFound = matchingKeyIndex >= 0;
        boolean mapHasOnlyIntegerIndices = matchingKeyIndex == map.size() - 1;
        return atLeastOneIntegerIndexFound && mapHasOnlyIntegerIndices;
    }
}

