/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.servicebroker.autoconfigure.web.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

public class RequestIdentityInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String requestIdentity = request.getHeader("X-Broker-API-Request-Identity");
        if (StringUtils.hasLength((String)requestIdentity)) {
            response.addHeader("X-Broker-API-Request-Identity", requestIdentity);
        }
        return true;
    }
}

