/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.server.autoconfigure;

import com.github.zafarkhaja.semver.Version;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.info.GetInfoRequest;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.DefaultConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.ReactorCloudFoundryClient;
import org.cloudfoundry.reactor.tokenprovider.PasswordGrantTokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.AppNameGenerator;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryAppDeployer;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryAppNameGenerator;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryConnectionProperties;
import org.springframework.cloud.deployer.spi.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.deployer.spi.core.RuntimeEnvironmentInfo;
import org.springframework.cloud.deployer.spi.util.RuntimeVersionUtils;
import org.springframework.cloud.skipper.SkipperException;
import org.springframework.cloud.skipper.deployer.cloudfoundry.CloudFoundryPlatformProperties;
import org.springframework.cloud.skipper.domain.Deployer;
import org.springframework.cloud.skipper.domain.Platform;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CloudFoundryPlatformProperties.class})
public class CloudFoundryPlatformAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CloudFoundryPlatformAutoConfiguration.class);

    @Bean
    public Platform cloudFoundryPlatform(CloudFoundryPlatformProperties cloudFoundryPlatformProperties) {
        List deployers = cloudFoundryPlatformProperties.getAccounts().entrySet().stream().map(e -> this.createAndSaveCFAppDeployer((String)e.getKey(), (CloudFoundryPlatformProperties.CloudFoundryProperties)e.getValue())).collect(Collectors.toList());
        return new Platform("Cloud Foundry", deployers);
    }

    private Deployer createAndSaveCFAppDeployer(String account, CloudFoundryPlatformProperties.CloudFoundryProperties cloudFoundryProperties) {
        CloudFoundryDeploymentProperties deploymentProperties = cloudFoundryProperties.getDeployment();
        if (deploymentProperties == null) {
            deploymentProperties = new CloudFoundryDeploymentProperties();
        }
        CloudFoundryConnectionProperties connectionProperties = cloudFoundryProperties.getConnection();
        try {
            DefaultConnectionContext connectionContext = DefaultConnectionContext.builder().apiHost(connectionProperties.getUrl().getHost()).skipSslValidation(connectionProperties.isSkipSslValidation()).build();
            PasswordGrantTokenProvider tokenProvider = PasswordGrantTokenProvider.builder().username(connectionProperties.getUsername()).password(connectionProperties.getPassword()).build();
            ReactorCloudFoundryClient cloudFoundryClient = ReactorCloudFoundryClient.builder().connectionContext((ConnectionContext)connectionContext).tokenProvider((TokenProvider)tokenProvider).build();
            Version version = (Version)cloudFoundryClient.info().get(GetInfoRequest.builder().build()).map(response -> Version.valueOf((String)response.getApiVersion())).doOnNext(versionInfo -> logger.info("Connecting to Cloud Foundry with API Version {}", versionInfo)).block(Duration.ofSeconds(deploymentProperties.getApiTimeout()));
            RuntimeEnvironmentInfo runtimeEnvironmentInfo = new RuntimeEnvironmentInfo.Builder().implementationName(CloudFoundryAppDeployer.class.getSimpleName()).spiClass(AppDeployer.class).implementationVersion(RuntimeVersionUtils.getVersion(CloudFoundryAppDeployer.class)).platformType("Cloud Foundry").platformClientVersion(RuntimeVersionUtils.getVersion(cloudFoundryClient.getClass())).platformApiVersion(version.toString()).platformHostVersion("unknown").addPlatformSpecificInfo("API Endpoint", connectionProperties.getUrl().toString()).build();
            DefaultCloudFoundryOperations cloudFoundryOperations = DefaultCloudFoundryOperations.builder().cloudFoundryClient((CloudFoundryClient)cloudFoundryClient).organization(connectionProperties.getOrg()).space(connectionProperties.getSpace()).build();
            CloudFoundryAppNameGenerator appNameGenerator = new CloudFoundryAppNameGenerator(cloudFoundryProperties.getDeployment());
            appNameGenerator.afterPropertiesSet();
            CloudFoundryAppDeployer cfAppDeployer = new CloudFoundryAppDeployer((AppNameGenerator)appNameGenerator, deploymentProperties, (CloudFoundryOperations)cloudFoundryOperations, runtimeEnvironmentInfo);
            Deployer deployer = new Deployer(account, "cloudfoundry", (AppDeployer)cfAppDeployer);
            deployer.setDescription(String.format("org = [%s], space = [%s], url = [%s]", connectionProperties.getOrg(), connectionProperties.getSpace(), connectionProperties.getUrl()));
            return deployer;
        }
        catch (Exception e) {
            logger.error("Cloud Foundry platform account [{}] could not be registered: {}", (Object)account, (Object)e.getMessage());
            throw new SkipperException(e.getMessage());
        }
    }
}

