/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.server.autoconfigure;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.ContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.DefaultContainerFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesAppDeployer;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesClientFactory;
import org.springframework.cloud.deployer.spi.kubernetes.KubernetesDeployerProperties;
import org.springframework.cloud.skipper.deployer.kubernetes.KubernetesPlatformProperties;
import org.springframework.cloud.skipper.domain.Deployer;
import org.springframework.cloud.skipper.domain.Platform;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={KubernetesPlatformProperties.class})
public class KubernetesPlatformAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesPlatformAutoConfiguration.class);

    @Bean
    public Platform kubernetesPlatform(KubernetesPlatformProperties kubernetesPlatformProperties) {
        ArrayList deployers = new ArrayList();
        Map k8ConnectionProperties = kubernetesPlatformProperties.getAccounts();
        k8ConnectionProperties.forEach((key, value) -> {
            Deployer deployer = this.createAndSaveKubernetesAppDeployers((String)key, (KubernetesDeployerProperties)value);
            deployers.add(deployer);
        });
        return new Platform("Kubernetes", deployers);
    }

    protected Deployer createAndSaveKubernetesAppDeployers(String account, KubernetesDeployerProperties kubernetesProperties) {
        KubernetesClient kubernetesClient = KubernetesClientFactory.getKubernetesClient((KubernetesDeployerProperties)kubernetesProperties);
        DefaultContainerFactory containerFactory = new DefaultContainerFactory(kubernetesProperties);
        KubernetesAppDeployer kubernetesAppDeployer = new KubernetesAppDeployer(kubernetesProperties, kubernetesClient, (ContainerFactory)containerFactory);
        Deployer deployer = new Deployer(account, "kubernetes", (AppDeployer)kubernetesAppDeployer);
        deployer.setDescription(String.format("master url = [%s], namespace = [%s], api version = [%s]", kubernetesClient.getMasterUrl(), kubernetesClient.getNamespace(), kubernetesClient.getApiVersion()));
        return deployer;
    }
}

