/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.skipper.client.SkipperClient;
import org.springframework.cloud.skipper.client.SkipperServerException;
import org.springframework.cloud.skipper.domain.AboutResource;
import org.springframework.cloud.skipper.domain.CancelRequest;
import org.springframework.cloud.skipper.domain.CancelResponse;
import org.springframework.cloud.skipper.domain.Deployer;
import org.springframework.cloud.skipper.domain.Info;
import org.springframework.cloud.skipper.domain.InstallRequest;
import org.springframework.cloud.skipper.domain.Manifest;
import org.springframework.cloud.skipper.domain.PackageMetadata;
import org.springframework.cloud.skipper.domain.Release;
import org.springframework.cloud.skipper.domain.Repository;
import org.springframework.cloud.skipper.domain.RollbackRequest;
import org.springframework.cloud.skipper.domain.Template;
import org.springframework.cloud.skipper.domain.UpgradeRequest;
import org.springframework.cloud.skipper.domain.UploadRequest;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ClassPathResource;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.client.Traverson;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class DefaultSkipperClient
implements SkipperClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSkipperClient.class);
    protected final RestTemplate restTemplate;
    private final String baseUri;
    private final Traverson traverson;

    public DefaultSkipperClient(String baseUri) {
        this(baseUri, new RestTemplate());
    }

    public DefaultSkipperClient(String baseUri, RestTemplate restTemplate) {
        Assert.notNull((Object)baseUri, (String)"The provided baseURI must not be null.");
        Assert.notNull((Object)restTemplate, (String)"The provided restTemplate must not be null.");
        this.traverson = this.createTraverson(baseUri, (RestOperations)restTemplate);
        this.baseUri = baseUri;
        this.restTemplate = restTemplate;
    }

    @Override
    public Template getSpringCloudDeployerApplicationTemplate() {
        ClassPathResource resource = new ClassPathResource("/org/springframework/cloud/skipper/io/generic-template.yml");
        String genericTempateData = null;
        try {
            genericTempateData = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't load generic template", e);
        }
        Template template = new Template();
        template.setData(genericTempateData);
        try {
            template.setName(resource.getURL().toString());
        }
        catch (IOException e) {
            log.error("Could not get URL of resource " + resource.getDescription(), (Throwable)e);
            throw new SkipperServerException("Could not get URL of resource " + resource.getDescription(), e);
        }
        return template;
    }

    @Override
    public AboutResource info() {
        return (AboutResource)this.restTemplate.getForObject(this.baseUri + "/about", AboutResource.class, new Object[0]);
    }

    @Override
    public Info status(String releaseName) {
        ParameterizedTypeReference<Resource<Info>> typeReference = new ParameterizedTypeReference<Resource<Info>>(){};
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("releaseName", releaseName);
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(this.baseUri + "/release/status/{releaseName}", HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, uriVariables);
        return (Info)((Resource)resourceResponseEntity.getBody()).getContent();
    }

    @Override
    public Info status(String releaseName, int releaseVersion) {
        ParameterizedTypeReference<Resource<Info>> typeReference = new ParameterizedTypeReference<Resource<Info>>(){};
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("releaseName", releaseName);
        uriVariables.put("releaseVersion", Integer.toString(releaseVersion));
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(this.baseUri + "/release/status/{releaseName}/{releaseVersion}", HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, uriVariables);
        return (Info)((Resource)resourceResponseEntity.getBody()).getContent();
    }

    @Override
    public String manifest(String releaseName) {
        ParameterizedTypeReference<Resource<Manifest>> typeReference = new ParameterizedTypeReference<Resource<Manifest>>(){};
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("releaseName", releaseName);
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(this.baseUri + "/release/manifest/{releaseName}", HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, uriVariables);
        return ((Manifest)((Resource)resourceResponseEntity.getBody()).getContent()).getData();
    }

    @Override
    public String manifest(String releaseName, int releaseVersion) {
        ParameterizedTypeReference<Resource<Manifest>> typeReference = new ParameterizedTypeReference<Resource<Manifest>>(){};
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("releaseName", releaseName);
        uriVariables.put("releaseVersion", Integer.toString(releaseVersion));
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(this.baseUri + "/release/manifest/{releaseName}/{releaseVersion}", HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, uriVariables);
        return ((Manifest)((Resource)resourceResponseEntity.getBody()).getContent()).getData();
    }

    @Override
    public Resources<PackageMetadata> search(String name, boolean details) {
        ParameterizedTypeReference<Resources<PackageMetadata>> typeReference = new ParameterizedTypeReference<Resources<PackageMetadata>>(){};
        Traverson.TraversalBuilder traversalBuilder = this.traverson.follow(new String[]{"packageMetadata"});
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("size", 2000);
        if (StringUtils.hasText((String)name)) {
            parameters.put("name", name);
            traversalBuilder.follow(new String[]{"search", "findByNameContainingIgnoreCase"});
        }
        if (!details) {
            parameters.put("projection", "summary");
            parameters.put("sort", "name,asc");
        }
        return (Resources)traversalBuilder.withTemplateParameters(parameters).toObject((ParameterizedTypeReference)typeReference);
    }

    @Override
    public Release install(InstallRequest installRequest) {
        ParameterizedTypeReference<Resource<Release>> typeReference = new ParameterizedTypeReference<Resource<Release>>(){};
        String url = String.format("%s/%s/%s", this.baseUri, "package", "install");
        HttpEntity httpEntity = new HttpEntity((Object)installRequest);
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)typeReference, new Object[0]);
        return (Release)((Resource)resourceResponseEntity.getBody()).getContent();
    }

    @Override
    public Release upgrade(UpgradeRequest upgradeRequest) {
        String url = String.format("%s/%s/%s", this.baseUri, "release", "upgrade");
        log.debug("Posting UpgradeRequest to " + url + ". UpgradeRequest = " + upgradeRequest);
        return (Release)this.restTemplate.postForObject(url, (Object)upgradeRequest, Release.class, new Object[0]);
    }

    @Override
    public void delete(String releaseName, boolean deletePackage) {
        String url = null;
        if (deletePackage) {
            url = String.format("%s/%s/%s/%s", this.baseUri, "release", releaseName, "package");
            log.debug("Sending Delete request to " + url + " with the option to delete package");
        } else {
            url = String.format("%s/%s/%s", this.baseUri, "release", releaseName);
        }
        this.restTemplate.delete(url, new Object[]{deletePackage});
    }

    @Override
    public CancelResponse cancel(CancelRequest cancelRequest) {
        String url = String.format("%s/%s/%s", this.baseUri, "release", "cancel");
        log.debug("Posting CancelRequest to " + url + ". CancelRequest = " + cancelRequest);
        return (CancelResponse)this.restTemplate.postForObject(url, (Object)cancelRequest, CancelResponse.class, new Object[0]);
    }

    @Override
    public Release rollback(RollbackRequest rollbackRequest) {
        ParameterizedTypeReference<Resource<Release>> typeReference = new ParameterizedTypeReference<Resource<Release>>(){};
        String url = String.format("%s/%s/%s", this.baseUri, "release", "rollback");
        HttpEntity httpEntity = new HttpEntity((Object)rollbackRequest);
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)typeReference, new Object[0]);
        return (Release)((Resource)resourceResponseEntity.getBody()).getContent();
    }

    @Override
    public Release rollback(String releaseName, int releaseVersion) {
        return this.rollback(new RollbackRequest(releaseName, Integer.valueOf(releaseVersion)));
    }

    @Override
    public List<Release> list(String releaseNameLike) {
        ParameterizedTypeReference<Resources<Release>> typeReference = new ParameterizedTypeReference<Resources<Release>>(){};
        String url = StringUtils.hasText((String)releaseNameLike) ? String.format("%s/%s/%s/%s", this.baseUri, "release", "list", releaseNameLike) : String.format("%s/%s/%s", this.baseUri, "release", "list");
        return ((Resources)this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)typeReference, new HashMap()).getBody()).getContent().stream().collect(Collectors.toList());
    }

    @Override
    public Resources<Release> history(String releaseName) {
        ParameterizedTypeReference<Resources<Release>> typeReference = new ParameterizedTypeReference<Resources<Release>>(){};
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", releaseName);
        Traverson.TraversalBuilder traversalBuilder = this.traverson.follow(new String[]{"releases", "search", "findByNameIgnoreCaseContainingOrderByNameAscVersionDesc"});
        return (Resources)traversalBuilder.withTemplateParameters(parameters).toObject((ParameterizedTypeReference)typeReference);
    }

    @Override
    public Repository addRepository(String name, String rootUrl, String sourceUrl) {
        String url = String.format("%s/%s", this.baseUri, "repositories");
        Repository repository = new Repository();
        repository.setName(name);
        repository.setUrl(rootUrl);
        repository.setSourceUrl(sourceUrl);
        return (Repository)this.restTemplate.postForObject(url, (Object)repository, Repository.class, new Object[0]);
    }

    @Override
    public void deleteRepository(String name) {
        ParameterizedTypeReference<Resource<Repository>> typeReference = new ParameterizedTypeReference<Resource<Repository>>(){};
        Traverson.TraversalBuilder traversalBuilder = this.traverson.follow(new String[]{"repositories", "search", "findByName"});
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", name);
        Resource repositoryResource = (Resource)traversalBuilder.withTemplateParameters(parameters).toObject((ParameterizedTypeReference)typeReference);
        if (repositoryResource == null) {
            throw new IllegalStateException("The Repository with the " + name + " doesn't exist.");
        }
        this.restTemplate.delete(repositoryResource.getId().getHref(), new Object[0]);
    }

    @Override
    public Resources<Repository> listRepositories() {
        ParameterizedTypeReference<Resources<Repository>> typeReference = new ParameterizedTypeReference<Resources<Repository>>(){};
        Traverson.TraversalBuilder traversalBuilder = this.traverson.follow(new String[]{"repositories"});
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("size", 2000);
        return (Resources)traversalBuilder.withTemplateParameters(parameters).toObject((ParameterizedTypeReference)typeReference);
    }

    @Override
    public Resources<Deployer> listDeployers() {
        ParameterizedTypeReference<Resources<Deployer>> typeReference = new ParameterizedTypeReference<Resources<Deployer>>(){};
        Traverson.TraversalBuilder traversalBuilder = this.traverson.follow(new String[]{"deployers"});
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("size", 2000);
        return (Resources)traversalBuilder.withTemplateParameters(parameters).toObject((ParameterizedTypeReference)typeReference);
    }

    @Override
    public PackageMetadata upload(UploadRequest uploadRequest) {
        ParameterizedTypeReference<Resource<PackageMetadata>> typeReference = new ParameterizedTypeReference<Resource<PackageMetadata>>(){};
        String url = String.format("%s/%s/%s", this.baseUri, "package", "upload");
        log.debug("Uploading package {}-{} to repository {}.", new Object[]{uploadRequest.getName(), uploadRequest.getVersion(), uploadRequest.getRepoName()});
        HttpEntity httpEntity = new HttpEntity((Object)uploadRequest);
        ResponseEntity resourceResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)typeReference, new Object[0]);
        PackageMetadata packageMetadata = (PackageMetadata)((Resource)resourceResponseEntity.getBody()).getContent();
        return packageMetadata;
    }

    @Override
    public void packageDelete(String packageName) {
        String url = String.format("%s/%s/%s", this.baseUri, "package", packageName);
        this.restTemplate.delete(url, new Object[0]);
    }

    protected Traverson createTraverson(String baseUrl, RestOperations restOperations) {
        try {
            return new Traverson(new URI(baseUrl), new MediaType[]{MediaTypes.HAL_JSON}).setRestOperations(restOperations);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Bad URI syntax: " + baseUrl);
        }
    }
}

