/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.domain;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.skipper.SkipperException;
import org.springframework.cloud.skipper.domain.SpringCloudDeployerApplicationManifest;
import org.yaml.snakeyaml.Yaml;

public class SpringCloudDeployerApplicationManifestReader {
    private static final Logger logger = LoggerFactory.getLogger(SpringCloudDeployerApplicationManifestReader.class);

    public List<SpringCloudDeployerApplicationManifest> read(String manifest) {
        this.assertSupportedKinds(manifest);
        ArrayList<SpringCloudDeployerApplicationManifest> applicationSpecs = new ArrayList<SpringCloudDeployerApplicationManifest>();
        YAMLMapper mapper = new YAMLMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            MappingIterator it = mapper.readerFor(SpringCloudDeployerApplicationManifest.class).readValues(manifest);
            while (it.hasNextValue()) {
                SpringCloudDeployerApplicationManifest appKind = (SpringCloudDeployerApplicationManifest)it.next();
                applicationSpecs.add(appKind);
            }
        }
        catch (JsonMappingException e) {
            logger.error("Can't parse Package's manifest YAML = " + manifest);
            throw new SkipperException("JsonMappingException - Can't parse Package's manifest YAML = " + manifest, e);
        }
        catch (IOException e) {
            logger.error("Can't parse Package's manifest YAML = " + manifest);
            throw new SkipperException("IOException - Can't parse Package's manifest YAML = " + manifest, e);
        }
        return applicationSpecs;
    }

    private void assertSupportedKinds(String manifest) {
        Yaml yaml = new Yaml();
        Iterable object = yaml.loadAll(manifest);
        for (Object o : object) {
            this.assertSupportedKind(o);
        }
    }

    private void assertSupportedKind(Object object) {
        if (object == null) {
            throw new SkipperException("Can't parse manifest, it is empty");
        }
        if (!(object instanceof Map)) {
            throw new SkipperException("Can't parse manifest, it is not a map.  Manifest = " + object);
        }
        Map manifestAsMap = (Map)object;
        Object kindObject = manifestAsMap.get("kind");
        if (kindObject instanceof String) {
            String kind = (String)kindObject;
            if (kind.equalsIgnoreCase("SpringBootApp") || kind.equalsIgnoreCase("SpringCloudDeployerApplication")) {
                logger.debug("Found supported kind " + kind);
            } else {
                throw new SkipperException("No reader available to read all the kind " + kind);
            }
        }
    }
}

