/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.support.yaml;

abstract class YamlPathSegment {
    YamlPathSegment() {
    }

    protected abstract String getValueCode();

    protected abstract char getTypeCode();

    public boolean canEmpty() {
        return false;
    }

    public String toString() {
        return this.toNavString();
    }

    public abstract String toNavString();

    public abstract String toPropString();

    public abstract Integer toIndex();

    public abstract YamlPathSegmentType getType();

    public static YamlPathSegment valueAt(String key) {
        return new ValAtKey(key);
    }

    public static YamlPathSegment valueAt(int index) {
        return new AtIndex(index);
    }

    public static YamlPathSegment keyAt(String key) {
        return new KeyAtKey(key);
    }

    public static YamlPathSegment anyChild() {
        return AnyChild.INSTANCE;
    }

    public String encode() {
        return this.getTypeCode() + this.getValueCode();
    }

    public static YamlPathSegment decode(String code) {
        switch (code.charAt(0)) {
            case '*': {
                return YamlPathSegment.anyChild();
            }
            case '.': {
                return YamlPathSegment.valueAt(code.substring(1));
            }
            case '&': {
                return YamlPathSegment.keyAt(code.substring(1));
            }
            case '[': {
                return YamlPathSegment.valueAt(Integer.parseInt(code.substring(1)));
            }
        }
        throw new IllegalArgumentException("Can't decode YamlPathSegment from '" + code + "'");
    }

    public static final class KeyAtKey
    extends ValAtKey {
        KeyAtKey(String key) {
            super(key);
        }

        @Override
        public YamlPathSegmentType getType() {
            return YamlPathSegmentType.KEY_AT_KEY;
        }

        @Override
        protected char getTypeCode() {
            return '&';
        }
    }

    public static class ValAtKey
    extends YamlPathSegment {
        private String key;

        ValAtKey(String key) {
            this.key = key;
        }

        @Override
        public String toNavString() {
            if (this.key.indexOf(46) >= 0) {
                return "[" + this.key + "]";
            }
            return "." + this.key;
        }

        @Override
        public String toPropString() {
            return this.key;
        }

        @Override
        public YamlPathSegmentType getType() {
            return YamlPathSegmentType.VAL_AT_KEY;
        }

        @Override
        public Integer toIndex() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValAtKey other = (ValAtKey)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        @Override
        protected char getTypeCode() {
            return '.';
        }

        @Override
        protected String getValueCode() {
            return this.key;
        }
    }

    public static final class AtIndex
    extends YamlPathSegment {
        private int index;

        AtIndex(int index) {
            this.index = index;
        }

        @Override
        public String toNavString() {
            return "[" + this.index + "]";
        }

        @Override
        public String toPropString() {
            return "[" + this.index + "]";
        }

        @Override
        public YamlPathSegmentType getType() {
            return YamlPathSegmentType.VAL_AT_INDEX;
        }

        @Override
        public Integer toIndex() {
            return this.index;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.index;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AtIndex other = (AtIndex)obj;
            return this.index == other.index;
        }

        @Override
        protected char getTypeCode() {
            return '[';
        }

        @Override
        protected String getValueCode() {
            return "" + this.index;
        }
    }

    public static final class AnyChild
    extends YamlPathSegment {
        static AnyChild INSTANCE = new AnyChild();

        private AnyChild() {
        }

        @Override
        public String toNavString() {
            return ".*";
        }

        @Override
        public String toPropString() {
            return "*";
        }

        @Override
        public Integer toIndex() {
            return null;
        }

        @Override
        public YamlPathSegmentType getType() {
            return YamlPathSegmentType.ANY_CHILD;
        }

        @Override
        protected char getTypeCode() {
            return '*';
        }

        @Override
        protected String getValueCode() {
            return "";
        }
    }

    public static enum YamlPathSegmentType {
        VAL_AT_KEY,
        KEY_AT_KEY,
        VAL_AT_INDEX,
        ANY_CHILD;

    }
}

