/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth;

import java.util.ArrayDeque;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanAndScope;
import org.springframework.cloud.sleuth.Tracer;

public class ThreadLocalSpan {
    private final ThreadLocal<ArrayDeque<SpanAndScope>> currentSpanInScopeStack = new ThreadLocal();
    private final Tracer tracer;

    public ThreadLocalSpan(Tracer tracer) {
        this.tracer = tracer;
    }

    public void set(Span span) {
        Tracer.SpanInScope spanInScope = this.tracer.withSpan(span);
        SpanAndScope newSpanAndScope = new SpanAndScope(span, spanInScope);
        this.getCurrentSpanInScopeStack().addFirst(newSpanAndScope);
    }

    public SpanAndScope get() {
        return this.getCurrentSpanInScopeStack().peekFirst();
    }

    public void remove() {
        SpanAndScope spanAndScope = this.getCurrentSpanInScopeStack().pollFirst();
        if (spanAndScope == null) {
            return;
        }
        if (spanAndScope.getScope() != null) {
            spanAndScope.getScope().close();
        }
    }

    private ArrayDeque<SpanAndScope> getCurrentSpanInScopeStack() {
        ArrayDeque<SpanAndScope> stack = this.currentSpanInScopeStack.get();
        if (stack == null) {
            stack = new ArrayDeque();
            this.currentSpanInScopeStack.set(stack);
        }
        return stack;
    }
}

