/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.zipkin2;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinSenderCondition;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinSenderProperties;
import org.springframework.cloud.sleuth.zipkin2.CachingZipkinUrlExtractor;
import org.springframework.cloud.sleuth.zipkin2.LoadBalancerClientZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.RestTemplateSender;
import org.springframework.cloud.sleuth.zipkin2.StaticInstanceZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.ZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinRestTemplateCustomizer;
import org.springframework.cloud.sleuth.zipkin2.ZipkinRestTemplateWrapper;
import org.springframework.cloud.sleuth.zipkin2.ZipkinUrlExtractor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.Sender;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(name={"zipkinSender"})
@Conditional(value={ZipkinSenderCondition.class})
@EnableConfigurationProperties(value={ZipkinSenderProperties.class})
class ZipkinRestTemplateSenderConfiguration {
    private static final Log log = LogFactory.getLog(ZipkinRestTemplateSenderConfiguration.class);

    ZipkinRestTemplateSenderConfiguration() {
    }

    @Bean(value={"zipkinSender"})
    Sender restTemplateSender(ZipkinProperties zipkin, ZipkinRestTemplateCustomizer zipkinRestTemplateCustomizer, ZipkinUrlExtractor extractor) {
        ZipkinRestTemplateWrapper restTemplate = new ZipkinRestTemplateWrapper(zipkin, extractor);
        restTemplate = zipkinRestTemplateCustomizer.customizeTemplate((RestTemplate)restTemplate);
        return new RestTemplateSender((RestTemplate)restTemplate, zipkin.getBaseUrl(), (BytesEncoder)zipkin.getEncoder());
    }

    @Bean
    ZipkinUrlExtractor defaultZipkinUrlExtractor(ZipkinLoadBalancer zipkinLoadBalancer) {
        return new CachingZipkinUrlExtractor(zipkinLoadBalancer);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={LoadBalancerClient.class})
    static class DiscoveryClientZipkinUrlExtractorConfiguration {
        DiscoveryClientZipkinUrlExtractorConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnProperty(value={"spring.zipkin.discovery-client-enabled"}, havingValue="false")
        static class ZipkinClientNoOpConfiguration {
            ZipkinClientNoOpConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            ZipkinLoadBalancer staticInstanceLoadBalancer(ZipkinProperties zipkinProperties) {
                return new StaticInstanceZipkinLoadBalancer(zipkinProperties);
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnProperty(value={"spring.zipkin.discovery-client-enabled"}, havingValue="true", matchIfMissing=true)
        static class ZipkinClientLoadBalancedConfiguration {
            @Autowired(required=false)
            LoadBalancerClient client;

            ZipkinClientLoadBalancedConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            ZipkinLoadBalancer loadBalancerClientZipkinLoadBalancer(ZipkinProperties zipkinProperties) {
                return new LoadBalancerClientZipkinLoadBalancer(this.client, zipkinProperties);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.cloud.client.loadbalancer.LoadBalancerClient"})
    static class DefaultZipkinUrlExtractorConfiguration {
        @Autowired(required=false)
        LoadBalancerClient client;

        DefaultZipkinUrlExtractorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ZipkinLoadBalancer staticInstanceLoadBalancer(ZipkinProperties zipkinProperties) {
            return new StaticInstanceZipkinLoadBalancer(zipkinProperties);
        }
    }
}

