/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.reactor;

import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.io.Closeable;
import java.io.IOException;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.Queue;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.SleuthReactorProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.reactor.TraceReactorAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import reactor.core.publisher.Hooks;
import reactor.core.scheduler.Schedulers;

class HookRegisteringBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
Closeable {
    private static final Log log = LogFactory.getLog(HookRegisteringBeanDefinitionRegistryPostProcessor.class);
    final ConfigurableApplicationContext springContext;

    HookRegisteringBeanDefinitionRegistryPostProcessor(ConfigurableApplicationContext springContext) {
        this.springContext = springContext;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        HookRegisteringBeanDefinitionRegistryPostProcessor.setupHooks(this.springContext);
    }

    static void setupHooks(ConfigurableApplicationContext springContext) {
        ConfigurableEnvironment environment = springContext.getEnvironment();
        SleuthReactorProperties.InstrumentationType property = (SleuthReactorProperties.InstrumentationType)((Object)environment.getProperty("spring.sleuth.reactor.instrumentation-type", SleuthReactorProperties.InstrumentationType.class, (Object)SleuthReactorProperties.InstrumentationType.DECORATE_ON_EACH));
        if (HookRegisteringBeanDefinitionRegistryPostProcessor.wrapperNotOnClasspathHooksPropertyTurnedOn(property)) {
            log.warn((Object)"You have explicitly set the decorate hooks option but you're using an old version of Reactor. Please upgrade to the latest Boot version (at least 2.4.3). Will fall back to the previous reactor instrumentation mode");
            property = SleuthReactorProperties.InstrumentationType.DECORATE_ON_EACH;
        }
        if (property == SleuthReactorProperties.InstrumentationType.DECORATE_QUEUES) {
            HookRegisteringBeanDefinitionRegistryPostProcessor.addQueueWrapper(springContext);
            HookRegisteringBeanDefinitionRegistryPostProcessor.decorateScheduler(springContext);
        } else {
            Boolean decorateOnEach = (Boolean)environment.getProperty("spring.sleuth.reactor.decorate-on-each", Boolean.class, (Object)true);
            if (!decorateOnEach.booleanValue()) {
                log.warn((Object)"You're using the deprecated [spring.sleuth.reactor.decorate-on-each] property. Please use the [spring.sleuth.reactor.instrumentation-type] one instead.");
                HookRegisteringBeanDefinitionRegistryPostProcessor.decorateOnLast(ReactorSleuth.scopePassingSpanOperator((ConfigurableApplicationContext)springContext));
            } else if (property == SleuthReactorProperties.InstrumentationType.DECORATE_ON_EACH) {
                HookRegisteringBeanDefinitionRegistryPostProcessor.decorateOnEach(springContext);
                HookRegisteringBeanDefinitionRegistryPostProcessor.decorateOnLast(ReactorSleuth.onLastOperatorForOnEachInstrumentation((ConfigurableApplicationContext)springContext));
                HookRegisteringBeanDefinitionRegistryPostProcessor.decorateScheduler(springContext);
            } else if (property == SleuthReactorProperties.InstrumentationType.DECORATE_ON_LAST) {
                HookRegisteringBeanDefinitionRegistryPostProcessor.decorateOnLast(ReactorSleuth.scopePassingSpanOperator((ConfigurableApplicationContext)springContext));
                HookRegisteringBeanDefinitionRegistryPostProcessor.decorateScheduler(springContext);
            } else if (property == SleuthReactorProperties.InstrumentationType.MANUAL) {
                HookRegisteringBeanDefinitionRegistryPostProcessor.decorateOnLast(ReactorSleuth.springContextSpanOperator((ConfigurableApplicationContext)springContext));
            }
        }
    }

    private static boolean wrapperNotOnClasspathHooksPropertyTurnedOn(SleuthReactorProperties.InstrumentationType property) {
        return property == SleuthReactorProperties.InstrumentationType.DECORATE_QUEUES && !TraceReactorAutoConfiguration.TraceReactorConfiguration.IS_QUEUE_WRAPPER_ON_THE_CLASSPATH;
    }

    private static void decorateScheduler(ConfigurableApplicationContext springContext) {
        Schedulers.onScheduleHook((String)"sleuth", (Function)ReactorSleuth.scopePassingOnScheduleHook((ConfigurableApplicationContext)springContext));
    }

    private static void decorateOnLast(Function<? super Publisher<Object>, ? extends Publisher<Object>> function) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Decorating onLast operator instrumentation");
        }
        Hooks.onLastOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, function);
    }

    private static void decorateOnEach(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Decorating onEach operator instrumentation");
        }
        Hooks.onEachOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, (Function)ReactorSleuth.onEachOperatorForOnEachInstrumentation((ConfigurableApplicationContext)springContext));
    }

    static void addQueueWrapper(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Decorating queues");
        }
        Hooks.addQueueWrapper((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY, queue -> HookRegisteringBeanDefinitionRegistryPostProcessor.traceQueue(springContext, queue));
    }

    @Override
    public void close() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Cleaning up hooks");
        }
        Hooks.resetOnEachOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY);
        Hooks.resetOnLastOperator((String)TraceReactorAutoConfiguration.TraceReactorConfiguration.SLEUTH_TRACE_REACTOR_KEY);
        Hooks.removeQueueWrapper((String)"sleuth");
        Schedulers.resetOnScheduleHook((String)"sleuth");
    }

    private static Queue<?> traceQueue(ConfigurableApplicationContext springContext, final Queue<?> queue) {
        if (!springContext.isActive()) {
            return queue;
        }
        final CurrentTraceContext currentTraceContext = (CurrentTraceContext)springContext.getBean(CurrentTraceContext.class);
        final Queue<?> envelopeQueue = queue;
        return new AbstractQueue<Object>(){

            @Override
            public int size() {
                return envelopeQueue.size();
            }

            @Override
            public boolean offer(Object o) {
                TraceContext traceContext = currentTraceContext.get();
                return envelopeQueue.offer(new Envelope(o, traceContext));
            }

            @Override
            public Object poll() {
                Object object = envelopeQueue.poll();
                if (object == null) {
                    return null;
                }
                if (object instanceof Envelope) {
                    Envelope envelope = (Envelope)object;
                    this.restoreTheContext(envelope);
                    return envelope.body;
                }
                return object;
            }

            private void restoreTheContext(Envelope envelope) {
                if (envelope.traceContext != null) {
                    currentTraceContext.maybeScope(envelope.traceContext);
                }
            }

            @Override
            public Object peek() {
                Object peek = queue.peek();
                if (peek instanceof Envelope) {
                    Envelope envelope = (Envelope)peek;
                    this.restoreTheContext(envelope);
                    return envelope.body;
                }
                return peek;
            }

            @Override
            public Iterator<Object> iterator() {
                final Iterator iterator = queue.iterator();
                return new Iterator<Object>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Object next() {
                        Object next = iterator.next();
                        if (next instanceof Envelope) {
                            Envelope envelope = (Envelope)next;
                            this.restoreTheContext(envelope);
                            return envelope.body;
                        }
                        return next;
                    }
                };
            }
        };
    }

    static class Envelope {
        final Object body;
        final TraceContext traceContext;

        Envelope(Object body, TraceContext traceContext) {
            this.body = body;
            this.traceContext = traceContext;
        }
    }
}

