/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.web.client;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateCustomizer;
import org.springframework.cloud.commons.httpclient.HttpClientConfiguration;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.client.ConditionalnOnSleuthWebClient;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.instrument.web.client.HttpClientBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.LazyTraceClientHttpRequestInterceptor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRequestHttpHeadersFilter;
import org.springframework.cloud.sleuth.instrument.web.client.TraceResponseHttpHeadersFilter;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateCustomizer;
import org.springframework.cloud.sleuth.instrument.web.client.TraceUserInfoRestTemplateCustomizer;
import org.springframework.cloud.sleuth.instrument.web.client.TraceWebClientBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.UserInfoRestTemplateCustomizerBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.mvc.TracingClientHttpRequestInterceptor;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.vault.client.RestTemplateCustomizer;
import org.springframework.vault.client.WebClientCustomizer;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@Configuration(proxyBeanMethods=false)
@ConditionalnOnSleuthWebClient
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureBefore(value={HttpClientConfiguration.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
class TraceWebClientAutoConfiguration {
    TraceWebClientAutoConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={UserInfoRestTemplateCustomizer.class, OAuth2RestTemplate.class})
    protected static class TraceOAuthConfiguration {
        protected TraceOAuthConfiguration() {
        }

        @Bean
        static UserInfoRestTemplateCustomizerBeanPostProcessor userInfoRestTemplateCustomizerBeanPostProcessor(BeanFactory beanFactory) {
            return new UserInfoRestTemplateCustomizerBeanPostProcessor(beanFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        static UserInfoRestTemplateCustomizer traceUserInfoRestTemplateCustomizer(BeanFactory beanFactory) {
            return new TraceUserInfoRestTemplateCustomizer(beanFactory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebClient.class})
    @ConditionalOnProperty(value={"spring.sleuth.web.webclient.enabled"}, matchIfMissing=true)
    static class WebClientConfig {
        WebClientConfig() {
        }

        @Bean
        static TraceWebClientBeanPostProcessor traceWebClientBeanPostProcessor(ConfigurableApplicationContext springContext) {
            return new TraceWebClientBeanPostProcessor(springContext);
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={WebClientCustomizer.class})
        @ConditionalOnProperty(value={"spring.sleuth.vault.enabled"}, matchIfMissing=true)
        static class VaultWebClientCustomizerConfiguration {
            VaultWebClientCustomizerConfiguration() {
            }

            @Bean
            @Order(value=-2147483648)
            WebClientCustomizer traceVaultWebClientCustomizer(ConfigurableApplicationContext springContext) {
                return webClientBuilder -> new TraceWebClientBeanPostProcessor(springContext).postProcessAfterInitialization((Object)webClientBuilder, "");
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class})
    static class NettyConfiguration {
        NettyConfiguration() {
        }

        @Bean
        static HttpClientBeanPostProcessor httpClientBeanPostProcessor(ConfigurableApplicationContext springContext) {
            return new HttpClientBeanPostProcessor(springContext);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpHeadersFilter.class})
    @ConditionalOnMissingClass(value={"reactor.netty.http.client.HttpClient"})
    static class HttpHeadersFilterConfig {
        HttpHeadersFilterConfig() {
        }

        @Bean
        HttpHeadersFilter traceRequestHttpHeadersFilter(Tracer tracer, HttpClientHandler handler, Propagator propagator) {
            return new TraceRequestHttpHeadersFilter(tracer, handler, propagator);
        }

        @Bean
        HttpHeadersFilter traceResponseHttpHeadersFilter(Tracer tracer, HttpClientHandler handler, Propagator propagator) {
            return new TraceResponseHttpHeadersFilter(tracer, handler, propagator);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RestTemplate.class})
    static class RestTemplateConfig {
        RestTemplateConfig() {
        }

        @Bean
        public TracingClientHttpRequestInterceptor tracingClientHttpRequestInterceptor(CurrentTraceContext currentTraceContext, HttpClientHandler httpClientHandler) {
            return (TracingClientHttpRequestInterceptor)TracingClientHttpRequestInterceptor.create((CurrentTraceContext)currentTraceContext, (HttpClientHandler)httpClientHandler);
        }

        @Bean
        @Order
        TraceRestTemplateCustomizer traceRestTemplateCustomizer(BeanFactory beanFactory) {
            return new TraceRestTemplateCustomizer((ClientHttpRequestInterceptor)new LazyTraceClientHttpRequestInterceptor(beanFactory));
        }

        @Bean
        static TraceRestTemplateBeanPostProcessor traceRestTemplateBeanPostProcessor(ListableBeanFactory beanFactory) {
            return new TraceRestTemplateBeanPostProcessor((BeanFactory)beanFactory);
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={RestTemplateCustomizer.class})
        @ConditionalOnProperty(value={"spring.sleuth.vault.enabled"}, matchIfMissing=true)
        static class VaultRestTemplateCustomizerConfiguration {
            VaultRestTemplateCustomizerConfiguration() {
            }

            @Bean
            @Order(value=-2147483648)
            RestTemplateCustomizer traceVaultRestTemplateCustomizer(TraceRestTemplateCustomizer restTemplateCustomizer) {
                return arg_0 -> ((TraceRestTemplateCustomizer)restTemplateCustomizer).customize(arg_0);
            }
        }
    }
}

