/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave.instrument.web;

import brave.Tracer;
import brave.Tracing;
import brave.http.HttpClientParser;
import brave.http.HttpRequest;
import brave.http.HttpRequestParser;
import brave.http.HttpResponseParser;
import brave.http.HttpServerParser;
import brave.http.HttpTracing;
import brave.http.HttpTracingCustomizer;
import brave.propagation.CurrentTraceContext;
import brave.sampler.SamplerFunctions;
import java.util.List;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.SamplerFunction;
import org.springframework.cloud.sleuth.autoconfig.brave.instrument.web.BraveHttpBridgeConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.ConditionalOnSleuthHttp;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.SleuthHttpProperties;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.SleuthWebProperties;
import org.springframework.cloud.sleuth.brave.bridge.BraveHttpRequestParser;
import org.springframework.cloud.sleuth.brave.bridge.BraveHttpResponseParser;
import org.springframework.cloud.sleuth.brave.bridge.BraveSamplerFunction;
import org.springframework.cloud.sleuth.brave.instrument.web.BraveSpanFromContextRetriever;
import org.springframework.cloud.sleuth.brave.instrument.web.CompositeHttpSampler;
import org.springframework.cloud.sleuth.brave.instrument.web.SkipPatternHttpClientSampler;
import org.springframework.cloud.sleuth.brave.instrument.web.SkipPatternHttpServerSampler;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;
import org.springframework.cloud.sleuth.instrument.web.SpanFromContextRetriever;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.lang.Nullable;
import reactor.util.context.Context;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSleuthHttp
@ConditionalOnClass(value={HttpTracing.class})
@EnableConfigurationProperties(value={SleuthWebProperties.class, SleuthHttpProperties.class})
@Import(value={BraveHttpBridgeConfiguration.class})
public class BraveHttpConfiguration {
    @Bean
    @ConditionalOnMissingBean
    HttpTracing httpTracing(Tracing tracing, @Nullable SkipPatternProvider provider, @Nullable HttpClientParser clientParser, @Nullable HttpServerParser serverParser, BeanFactory beanFactory, @Nullable List<HttpTracingCustomizer> httpTracingCustomizers) {
        HttpTracing.Builder builder = this.httpTracingBuilder(tracing, provider, beanFactory);
        HttpRequestParser httpClientRequestParser = this.httpRequestParser(beanFactory, "sleuthHttpClientRequestParser");
        HttpResponseParser httpClientResponseParser = this.httpResponseParser(beanFactory, "sleuthHttpClientResponseParser");
        HttpRequestParser httpServerRequestParser = this.httpRequestParser(beanFactory, "sleuthHttpServerRequestParser");
        HttpResponseParser httpServerResponseParser = this.httpResponseParser(beanFactory, "sleuthHttpServerResponseParser");
        if (httpClientRequestParser != null || httpClientResponseParser != null) {
            if (httpClientRequestParser != null) {
                builder.clientRequestParser(httpClientRequestParser);
            }
            if (httpClientResponseParser != null) {
                builder.clientResponseParser(httpClientResponseParser);
            }
        } else if (clientParser != null) {
            builder.clientParser(clientParser);
        }
        if (httpServerRequestParser != null || httpServerResponseParser != null) {
            if (httpServerRequestParser != null) {
                builder.serverRequestParser(httpServerRequestParser);
            }
            if (httpServerResponseParser != null) {
                builder.serverResponseParser(httpServerResponseParser);
            }
        } else if (serverParser != null) {
            builder.serverParser(serverParser);
        }
        if (httpTracingCustomizers != null) {
            for (HttpTracingCustomizer customizer : httpTracingCustomizers) {
                customizer.customize(builder);
            }
        }
        return builder.build();
    }

    private HttpRequestParser httpRequestParser(BeanFactory beanFactory, String name) {
        return beanFactory.containsBean(name) ? this.toBraveHttpRequestParser(beanFactory, name) : null;
    }

    private HttpResponseParser httpResponseParser(BeanFactory beanFactory, String name) {
        return beanFactory.containsBean(name) ? this.toBraveHttpResponseParser(beanFactory, name) : null;
    }

    @NotNull
    private HttpTracing.Builder httpTracingBuilder(Tracing tracing, @Nullable SkipPatternProvider provider, BeanFactory beanFactory) {
        brave.sampler.SamplerFunction<HttpRequest> httpClientSampler = this.toBraveSampler(beanFactory, "sleuthHttpClientSampler");
        brave.sampler.SamplerFunction<HttpRequest> httpServerSampler = this.httpServerSampler(beanFactory);
        brave.sampler.SamplerFunction<HttpRequest> combinedSampler = this.combineUserProvidedSamplerWithSkipPatternSampler(httpServerSampler, provider);
        return HttpTracing.newBuilder((Tracing)tracing).clientSampler(httpClientSampler).serverSampler(combinedSampler);
    }

    @Nullable
    private brave.sampler.SamplerFunction<HttpRequest> httpServerSampler(BeanFactory beanFactory) {
        return beanFactory.containsBean("sleuthHttpServerSampler") ? this.toBraveSampler(beanFactory, "sleuthHttpServerSampler") : null;
    }

    private HttpRequestParser toBraveHttpRequestParser(BeanFactory beanFactory, String beanName) {
        Object bean = beanFactory.getBean(beanName);
        HttpRequestParser parser = bean instanceof HttpRequestParser ? (HttpRequestParser)bean : (bean instanceof org.springframework.cloud.sleuth.http.HttpRequestParser ? BraveHttpRequestParser.toBrave((org.springframework.cloud.sleuth.http.HttpRequestParser)((org.springframework.cloud.sleuth.http.HttpRequestParser)bean)) : null);
        return this.returnOrThrow(bean, parser, beanName, HttpRequestParser.class, org.springframework.cloud.sleuth.http.HttpRequestParser.class);
    }

    private HttpResponseParser toBraveHttpResponseParser(BeanFactory beanFactory, String beanName) {
        Object bean = beanFactory.getBean(beanName);
        HttpResponseParser parser = bean instanceof HttpResponseParser ? (HttpResponseParser)bean : (bean instanceof org.springframework.cloud.sleuth.http.HttpResponseParser ? BraveHttpResponseParser.toBrave((org.springframework.cloud.sleuth.http.HttpResponseParser)((org.springframework.cloud.sleuth.http.HttpResponseParser)bean)) : null);
        return this.returnOrThrow(bean, parser, beanName, HttpResponseParser.class, org.springframework.cloud.sleuth.http.HttpResponseParser.class);
    }

    private brave.sampler.SamplerFunction<HttpRequest> toBraveSampler(BeanFactory beanFactory, String beanName) {
        Object bean = beanFactory.getBean(beanName);
        brave.sampler.SamplerFunction braveSampler = bean instanceof brave.sampler.SamplerFunction ? (brave.sampler.SamplerFunction)bean : (bean instanceof SamplerFunction ? BraveSamplerFunction.toHttpBrave((SamplerFunction)((SamplerFunction)bean)) : null);
        return this.returnOrThrow(bean, braveSampler, beanName, brave.sampler.SamplerFunction.class, SamplerFunction.class);
    }

    @NotNull
    private <T> T returnOrThrow(Object bean, T convertedBean, String name, Class brave, Class sleuth) {
        if (convertedBean == null) {
            throw new IllegalStateException("Bean with name [" + name + "] is of type [" + bean.getClass() + "] and only [" + brave.getCanonicalName() + "] and [" + sleuth.getCanonicalName() + "] are supported");
        }
        return convertedBean;
    }

    private brave.sampler.SamplerFunction<HttpRequest> combineUserProvidedSamplerWithSkipPatternSampler(@Nullable brave.sampler.SamplerFunction<HttpRequest> serverSampler, @Nullable SkipPatternProvider provider) {
        SkipPatternHttpServerSampler skipPatternSampler;
        SkipPatternHttpServerSampler skipPatternHttpServerSampler = skipPatternSampler = provider != null ? new SkipPatternHttpServerSampler(provider) : null;
        if (serverSampler == null && skipPatternSampler == null) {
            return SamplerFunctions.deferDecision();
        }
        if (serverSampler == null) {
            return skipPatternSampler;
        }
        if (skipPatternSampler == null) {
            return serverSampler;
        }
        return new CompositeHttpSampler((brave.sampler.SamplerFunction)skipPatternSampler, serverSampler);
    }

    @Bean
    @ConditionalOnMissingBean(name={"sleuthHttpClientSampler"})
    brave.sampler.SamplerFunction<HttpRequest> sleuthHttpClientSampler(SleuthWebProperties sleuthWebProperties) {
        String skipPattern = sleuthWebProperties.getClient().getSkipPattern();
        if (skipPattern == null) {
            return SamplerFunctions.deferDecision();
        }
        return new SkipPatternHttpClientSampler(Pattern.compile(skipPattern));
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Context.class})
    static class BraveWebFilterConfiguration {
        BraveWebFilterConfiguration() {
        }

        @Bean
        SpanFromContextRetriever braveSpanFromContextRetriever(CurrentTraceContext currentTraceContext, Tracer tracer) {
            return new BraveSpanFromContextRetriever(currentTraceContext, tracer);
        }
    }
}

