/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.task;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.instrument.task.TraceApplicationRunnerBeanPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.task.TraceCommandLineRunnerBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.task.TraceTaskExecutionListener;
import org.springframework.cloud.task.listener.TaskExecutionListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={TaskExecutionListener.class})
@ConditionalOnProperty(value={"spring.sleuth.task.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={BraveAutoConfiguration.class})
public class TraceTaskAutoConfiguration {
    @Bean
    TraceTaskExecutionListener traceTaskExecutionListener(Tracer tracer, @Value(value="${spring.application.name:default}") String appName) {
        return new TraceTaskExecutionListener(tracer, appName);
    }

    @Bean
    static TraceCommandLineRunnerBeanPostProcessor traceCommandLineRunnerBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceCommandLineRunnerBeanPostProcessor(beanFactory);
    }

    @Bean
    static TraceApplicationRunnerBeanPostProcessor traceApplicationRunnerBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceApplicationRunnerBeanPostProcessor(beanFactory);
    }
}

