/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.Span;
import brave.http.HttpServerRequest;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import org.springframework.cloud.sleuth.Span;
import org.springframework.http.server.reactive.ServerHttpRequest;

class BraveHttpServerRequest
implements org.springframework.cloud.sleuth.http.HttpServerRequest {
    final HttpServerRequest delegate;

    BraveHttpServerRequest(HttpServerRequest delegate) {
        this.delegate = delegate;
    }

    public String method() {
        return this.delegate.method();
    }

    public String route() {
        return this.delegate.route();
    }

    public Object unwrap() {
        return this.delegate.unwrap();
    }

    public Collection<String> headerNames() {
        return Collections.emptyList();
    }

    public Span.Kind spanKind() {
        return Span.Kind.valueOf((String)this.delegate.spanKind().name());
    }

    public String path() {
        return this.delegate.path();
    }

    public String url() {
        return this.delegate.url();
    }

    public String header(String name) {
        return this.delegate.header(name);
    }

    static HttpServerRequest toBrave(final org.springframework.cloud.sleuth.http.HttpServerRequest request) {
        if (request == null) {
            return null;
        }
        if (request instanceof BraveHttpServerRequest) {
            return ((BraveHttpServerRequest)request).delegate;
        }
        return new HttpServerRequest(){

            public Object unwrap() {
                return request.unwrap();
            }

            public String method() {
                return request.method();
            }

            public String path() {
                return request.path();
            }

            public String url() {
                return request.url();
            }

            public String header(String name) {
                return request.header(name);
            }

            public boolean parseClientIpAndPort(Span span) {
                boolean clientIpAndPortParsed = super.parseClientIpAndPort(span);
                if (clientIpAndPortParsed) {
                    return true;
                }
                return this.resolveFromInetAddress(span);
            }

            private boolean resolveFromInetAddress(Span span) {
                Object delegate = request.unwrap();
                if (delegate instanceof ServerHttpRequest) {
                    InetSocketAddress addr = ((ServerHttpRequest)delegate).getRemoteAddress();
                    if (addr == null) {
                        return false;
                    }
                    return span.remoteIpAndPort(addr.getAddress().getHostAddress(), addr.getPort());
                }
                return false;
            }
        };
    }
}

