/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.messaging;

import brave.kafka.clients.KafkaTracing;
import org.apache.kafka.clients.producer.Producer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.kafka.core.ProducerPostProcessor;

class TraceProducerPostProcessor<K, V>
implements ProducerPostProcessor<K, V> {
    private final BeanFactory beanFactory;
    private KafkaTracing kafkaTracing;

    TraceProducerPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    private KafkaTracing kafkaTracing() {
        if (this.kafkaTracing == null) {
            this.kafkaTracing = (KafkaTracing)this.beanFactory.getBean(KafkaTracing.class);
        }
        return this.kafkaTracing;
    }

    public Producer<K, V> apply(Producer<K, V> kvProducer) {
        return this.kafkaTracing().producer(kvProducer);
    }
}

