/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.reactor.ScopePassingSpanSubscriber;
import org.springframework.cloud.sleuth.instrument.reactor.SleuthContextOperator;
import org.springframework.cloud.sleuth.internal.LazyBean;
import org.springframework.context.ConfigurableApplicationContext;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public abstract class ReactorSleuth {
    private static final Log log = LogFactory.getLog(ReactorSleuth.class);

    private ReactorSleuth() {
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> scopePassingSpanOperator(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Scope passing operator [" + springContext + "]"));
        }
        LazyBean<CurrentTraceContext> lazyCurrentTraceContext = LazyBean.create(springContext, CurrentTraceContext.class);
        return Operators.liftPublisher((p, sub) -> {
            TraceContext parent;
            CurrentTraceContext currentTraceContext;
            if (p instanceof Fuseable.ScalarCallable) {
                return sub;
            }
            if (!springContext.isActive()) {
                if (log.isTraceEnabled()) {
                    String message = "Spring Context [" + springContext + "] is not yet refreshed. This is unexpected. Reactor Context is [" + ReactorSleuth.context(sub) + "] and name is [" + ReactorSleuth.name(sub) + "]";
                    log.trace((Object)message);
                }
                return sub;
            }
            Context context = ReactorSleuth.context(sub);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Spring context [" + springContext + "], Reactor context [" + context + "], name [" + ReactorSleuth.name(sub) + "]"));
            }
            if ((currentTraceContext = (CurrentTraceContext)lazyCurrentTraceContext.get()) == null) {
                if (log.isTraceEnabled()) {
                    String message = "Spring Context [" + springContext + "] did not return a CurrentTraceContext. Reactor Context is [" + context + "] and name is [" + ReactorSleuth.name(sub) + "]";
                    log.trace((Object)message);
                }
                return sub;
            }
            context = ReactorSleuth.contextWithBeans(context, springContext, sub);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Spring context [" + springContext + "], Reactor context [" + context + "], name [" + ReactorSleuth.name(sub) + "]"));
            }
            if ((parent = ReactorSleuth.traceContext(context, currentTraceContext)) == null) {
                return sub;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating a scope passing span subscriber with Reactor Context [" + context + "] and name [" + ReactorSleuth.name(sub) + "]"));
            }
            return new ScopePassingSpanSubscriber(sub, context, currentTraceContext, parent);
        });
    }

    private static <T> Context contextWithBeans(Context context, ConfigurableApplicationContext springContext, CoreSubscriber<? super T> sub) {
        if (!context.hasKey(Tracer.class)) {
            context = context.put(Tracer.class, springContext.getBean(Tracer.class));
        }
        if (!context.hasKey(CurrentTraceContext.class)) {
            context = context.put(CurrentTraceContext.class, springContext.getBean(CurrentTraceContext.class));
        }
        return context;
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> springContextSpanOperator(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Spring Context passing operator [" + springContext + "]"));
        }
        return Operators.liftPublisher((p, sub) -> {
            if (p instanceof Fuseable.ScalarCallable) {
                return sub;
            }
            if (!springContext.isActive()) {
                return sub;
            }
            Context context = ReactorSleuth.contextWithBeans(ReactorSleuth.context(sub), springContext, sub);
            return new SleuthContextOperator(context, sub);
        });
    }

    private static <T> Context context(CoreSubscriber<? super T> sub) {
        try {
            return sub.currentContext();
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception occurred while trying to retrieve the context", (Throwable)ex);
            }
            return Context.empty();
        }
    }

    static String name(CoreSubscriber<?> sub) {
        return Scannable.from(sub).name();
    }

    static TraceContext traceContext(Context context, CurrentTraceContext fallback) {
        if (context.hasKey(TraceContext.class)) {
            return (TraceContext)context.get(TraceContext.class);
        }
        return fallback.context();
    }
}

