/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.MessageHeaderPropagatorSetter;
import org.springframework.cloud.sleuth.instrument.messaging.MessageSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.messaging.SpanAndScope;
import org.springframework.cloud.sleuth.instrument.messaging.ThreadLocalSpan;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.cloud.stream.binder.BinderTypeRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class TracingChannelInterceptor
extends ChannelInterceptorAdapter
implements ExecutorChannelInterceptor,
ApplicationContextAware {
    public static final String STREAM_DIRECT_CHANNEL = "org.springframework.cloud.stream.messaging.DirectWithAttributesChannel";
    private static final Log log = LogFactory.getLog(TracingChannelInterceptor.class);
    private static final String REMOTE_SERVICE_NAME = "broker";
    final Tracer tracer;
    final Propagator.Setter<MessageHeaderAccessor> injector;
    final Propagator.Getter<MessageHeaderAccessor> extractor;
    final MessageSpanCustomizer messageSpanCustomizer;
    private final boolean hasDirectChannelClass;
    private final boolean hasBinderTypeRegistry;
    private final Class<?> directWithAttributesChannelClass;
    private ApplicationContext applicationContext;
    private final Propagator propagator;
    private final ThreadLocalSpan threadLocalSpan = new ThreadLocalSpan();
    private final Function<String, String> remoteServiceNameMapper;

    public TracingChannelInterceptor(Tracer tracer, Propagator propagator, Propagator.Setter<MessageHeaderAccessor> setter, Propagator.Getter<MessageHeaderAccessor> getter, Function<String, String> remoteServiceNameMapper, MessageSpanCustomizer messageSpanCustomizer) {
        this.tracer = tracer;
        this.propagator = propagator;
        this.injector = setter;
        this.extractor = getter;
        this.remoteServiceNameMapper = remoteServiceNameMapper;
        this.messageSpanCustomizer = messageSpanCustomizer;
        this.hasDirectChannelClass = ClassUtils.isPresent((String)"org.springframework.integration.channel.DirectChannel", null);
        this.hasBinderTypeRegistry = ClassUtils.isPresent((String)"org.springframework.cloud.stream.binder.BinderTypeRegistry", null);
        this.directWithAttributesChannelClass = ClassUtils.isPresent((String)STREAM_DIRECT_CHANNEL, null) ? ClassUtils.resolveClassName((String)STREAM_DIRECT_CHANNEL, null) : null;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        if (this.emptyMessage(message)) {
            return message;
        }
        Message<?> retrievedMessage = this.getMessage(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received a message in pre-send " + retrievedMessage));
        }
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(retrievedMessage);
        Span.Builder spanBuilder = this.propagator.extract((Object)headers, this.extractor);
        MessageHeaderPropagatorSetter.removeAnyTraceHeaders(headers, this.propagator.fields());
        spanBuilder = spanBuilder.kind(Span.Kind.PRODUCER);
        spanBuilder = this.messageSpanCustomizer.customizeSend(spanBuilder, message, channel).remoteServiceName(this.toRemoteServiceName(headers));
        Span span = spanBuilder.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracted result from headers " + span));
        }
        this.setSpanInScope(span);
        this.propagator.inject(span.context(), (Object)headers, this.injector);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a new span in pre send " + span));
        }
        Message<?> outputMessage = this.outputMessage(message, retrievedMessage, headers);
        if (this.isDirectChannel(channel)) {
            this.beforeHandle(outputMessage, channel, null);
        }
        return outputMessage;
    }

    private void setSpanInScope(Span span) {
        Tracer.SpanInScope spanInScope = this.tracer.withSpan(span);
        this.threadLocalSpan.set(new SpanAndScope(span, spanInScope));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Put span in scope " + span));
        }
    }

    private String toRemoteServiceName(MessageHeaderAccessor headers) {
        String binderName;
        String remoteServiceName;
        BinderTypeRegistry typeRegistry;
        Iterator iterator;
        for (String key : headers.getMessageHeaders().keySet()) {
            String remoteServiceName2 = this.remoteServiceNameMapper.apply(key);
            if (!StringUtils.hasText((String)remoteServiceName2)) continue;
            return remoteServiceName2;
        }
        if (this.hasBinderTypeRegistry && this.applicationContext != null && (iterator = (typeRegistry = (BinderTypeRegistry)this.applicationContext.getBean(BinderTypeRegistry.class)).getAll().entrySet().iterator()).hasNext() && StringUtils.hasText((String)(remoteServiceName = this.remoteServiceNameMapper.apply(binderName = (String)iterator.next().getKey())))) {
            return remoteServiceName;
        }
        return REMOTE_SERVICE_NAME;
    }

    private Message<?> outputMessage(Message<?> originalMessage, Message<?> retrievedMessage, MessageHeaderAccessor additionalHeaders) {
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(originalMessage);
        if (originalMessage instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)originalMessage;
            headers.copyHeaders(MessageHeaderPropagatorSetter.propagationHeaders(additionalHeaders.getMessageHeaders(), this.propagator.fields()));
            return new ErrorMessage((Throwable)errorMessage.getPayload(), this.isWebSockets(headers) ? headers.getMessageHeaders() : new MessageHeaders((Map)headers.getMessageHeaders()), errorMessage.getOriginalMessage());
        }
        headers.copyHeaders((Map)new MessageHeaders((Map)additionalHeaders.getMessageHeaders()));
        return new GenericMessage(retrievedMessage.getPayload(), this.isWebSockets(headers) ? headers.getMessageHeaders() : new MessageHeaders((Map)headers.getMessageHeaders()));
    }

    private boolean isWebSockets(MessageHeaderAccessor headerAccessor) {
        return headerAccessor.getMessageHeaders().containsKey((Object)"stompCommand") || headerAccessor.getMessageHeaders().containsKey((Object)"simpMessageType");
    }

    private boolean isDirectChannel(MessageChannel channel) {
        boolean directChannel;
        Class targetClass = AopUtils.getTargetClass((Object)channel);
        boolean bl = directChannel = this.hasDirectChannelClass && DirectChannel.class.isAssignableFrom(targetClass);
        if (!directChannel) {
            return false;
        }
        if (this.directWithAttributesChannelClass == null) {
            return true;
        }
        return !this.isStreamSpecialDirectChannel(targetClass);
    }

    private boolean isStreamSpecialDirectChannel(Class<?> targetClass) {
        return this.directWithAttributesChannelClass.isAssignableFrom(targetClass);
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        if (this.emptyMessage(message)) {
            return;
        }
        if (this.isDirectChannel(channel)) {
            this.afterMessageHandled(message, channel, null, ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will finish the current span after completion " + this.tracer.currentSpan()));
        }
        this.finishSpan(ex);
    }

    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
        if (this.emptyMessage(message)) {
            return message;
        }
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received a message in post-receive " + message));
        }
        Span result = this.propagator.extract((Object)headers, this.extractor).start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracted result from headers " + result));
        }
        Span span = this.consumerSpanReceive(message, channel, headers, result);
        this.setSpanInScope(span);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a new span that will be injected in the headers " + span));
        }
        this.propagator.inject(span.context(), (Object)headers, this.injector);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a new span in post receive " + span));
        }
        headers.setImmutable();
        if (message instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)message;
            return new ErrorMessage((Throwable)errorMessage.getPayload(), headers.getMessageHeaders(), errorMessage.getOriginalMessage());
        }
        return new GenericMessage(message.getPayload(), headers.getMessageHeaders());
    }

    private Span consumerSpanReceive(Message<?> message, MessageChannel channel, MessageHeaderAccessor headers, Span result) {
        Span.Builder builder = this.tracer.spanBuilder().setParent(result.context());
        MessageHeaderPropagatorSetter.removeAnyTraceHeaders(headers, this.propagator.fields());
        builder = builder.kind(Span.Kind.CONSUMER);
        builder = this.messageSpanCustomizer.customizeReceive(builder, message, channel);
        builder = builder.remoteServiceName(this.toRemoteServiceName(headers));
        return builder.start();
    }

    public void afterReceiveCompletion(Message<?> message, MessageChannel channel, Exception ex) {
        if (this.emptyMessage(message)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will finish the current span after receive completion " + this.tracer.currentSpan()));
        }
        this.finishSpan(ex);
    }

    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
        if (this.emptyMessage(message)) {
            return message;
        }
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received a message in before handle " + message));
        }
        Span consumerSpan = this.consumerSpan(message, channel, headers);
        Span handle = this.tracer.nextSpan(consumerSpan);
        handle = this.messageSpanCustomizer.customizeHandle(handle, message, channel).start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created consumer span " + handle));
        }
        this.setSpanInScope(handle);
        MessageHeaderPropagatorSetter.removeAnyTraceHeaders(headers, this.propagator.fields());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a new span in before handle " + handle));
        }
        if (message instanceof ErrorMessage) {
            return new ErrorMessage((Throwable)message.getPayload(), headers.getMessageHeaders());
        }
        headers.setImmutable();
        return new GenericMessage(message.getPayload(), headers.getMessageHeaders());
    }

    private Span consumerSpan(Message<?> message, MessageChannel channel, MessageHeaderAccessor headers) {
        Span.Builder consumerSpanBuilder = this.propagator.extract((Object)headers, this.extractor);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracted result from headers - will finish it immediately " + consumerSpanBuilder));
        }
        consumerSpanBuilder.kind(Span.Kind.CONSUMER).start();
        consumerSpanBuilder.remoteServiceName(REMOTE_SERVICE_NAME);
        consumerSpanBuilder = this.messageSpanCustomizer.customizeHandle(consumerSpanBuilder, message, channel);
        Span consumerSpan = consumerSpanBuilder.start();
        consumerSpan.end();
        return consumerSpan;
    }

    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
        if (this.emptyMessage(message)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will finish the current span after message handled " + this.tracer.currentSpan()));
        }
        this.finishSpan(ex);
    }

    void finishSpan(Exception error) {
        SpanAndScope spanAndScope = this.getSpanFromThreadLocal();
        if (spanAndScope == null) {
            return;
        }
        Span span = spanAndScope.span;
        Tracer.SpanInScope scope = spanAndScope.scope;
        if (span.isNoop()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Span " + span + " is noop - will stope the scope"));
            }
            scope.close();
            return;
        }
        if (error != null) {
            String message = error.getMessage();
            if (message == null) {
                message = error.getClass().getSimpleName();
            }
            span.tag("error", message);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will finish the and its corresponding scope " + span));
        }
        span.end();
        scope.close();
    }

    private SpanAndScope getSpanFromThreadLocal() {
        SpanAndScope span = this.threadLocalSpan.get();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Took span [" + span + "] from thread local"));
        }
        this.threadLocalSpan.remove();
        return span;
    }

    private MessageHeaderAccessor mutableHeaderAccessor(Message<?> message) {
        MessageHeaderAccessor accessor = MessageHeaderAccessor.getAccessor(message, MessageHeaderAccessor.class);
        if (accessor != null && accessor.isMutable()) {
            return accessor;
        }
        MessageHeaderAccessor headers = MessageHeaderAccessor.getMutableAccessor(message);
        headers.setLeaveMutable(true);
        return headers;
    }

    private Message<?> getMessage(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof MessagingException) {
            MessagingException e = (MessagingException)payload;
            Message<?> failedMessage = e.getFailedMessage();
            return failedMessage != null ? failedMessage : message;
        }
        return message;
    }

    private boolean emptyMessage(Message<?> message) {
        return message == null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

