/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorHooksHelper;
import org.springframework.cloud.sleuth.instrument.reactor.ScopePassingSpanSubscriber;
import org.springframework.cloud.sleuth.instrument.reactor.SleuthContextOperator;
import org.springframework.cloud.sleuth.internal.LazyBean;
import org.springframework.context.ConfigurableApplicationContext;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public abstract class ReactorSleuth {
    private static final Log log = LogFactory.getLog(ReactorSleuth.class);

    private ReactorSleuth() {
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> scopePassingSpanOperator(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Scope passing operator [" + springContext + "]"));
        }
        LazyBean<CurrentTraceContext> lazyCurrentTraceContext = LazyBean.create(springContext, CurrentTraceContext.class);
        LazyBean<Tracer> lazyTracer = LazyBean.create(springContext, Tracer.class);
        return Operators.liftPublisher(p -> !(p instanceof Fuseable.ScalarCallable), ReactorSleuth.liftFunction(springContext, lazyCurrentTraceContext, lazyTracer));
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> onEachOperatorForOnEachInstrumentation(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Scope passing operator [" + springContext + "]"));
        }
        LazyBean<CurrentTraceContext> lazyCurrentTraceContext = LazyBean.create(springContext, CurrentTraceContext.class);
        LazyBean<Tracer> lazyTracer = LazyBean.create(springContext, Tracer.class);
        Predicate<Publisher> shouldDecorate = ReactorHooksHelper::shouldDecorate;
        BiFunction lifter = ReactorSleuth.liftFunction(springContext, lazyCurrentTraceContext, lazyTracer);
        return ReactorHooksHelper.liftPublisher(shouldDecorate, lifter);
    }

    static <O> BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super O>> liftFunction(ConfigurableApplicationContext springContext, LazyBean<CurrentTraceContext> lazyCurrentTraceContext, LazyBean<Tracer> lazyTracer) {
        return (p, sub) -> {
            CurrentTraceContext currentTraceContext;
            if (!springContext.isActive() || !springContext.isRunning()) {
                if (log.isTraceEnabled()) {
                    String message = "Spring Context [" + springContext + "] is not yet refreshed. This is unexpected. Reactor Context is [" + ReactorSleuth.context(sub) + "] and name is [" + ReactorSleuth.name(sub) + "]";
                    log.trace((Object)message);
                }
                return sub;
            }
            Context context = ReactorSleuth.context(sub);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Spring context [" + springContext + "], Reactor context [" + context + "], name [" + ReactorSleuth.name(sub) + "]"));
            }
            if ((currentTraceContext = (CurrentTraceContext)lazyCurrentTraceContext.get()) == null) {
                if (log.isTraceEnabled()) {
                    String message = "Spring Context [" + springContext + "] did not return a CurrentTraceContext. Reactor Context is [" + context + "] and name is [" + ReactorSleuth.name(sub) + "]";
                    log.trace((Object)message);
                }
                return sub;
            }
            TraceContext parent = ReactorSleuth.traceContext(context, currentTraceContext);
            if (parent == null) {
                return sub;
            }
            if (sub instanceof ScopePassingSpanSubscriber) {
                ScopePassingSpanSubscriber scopePassing = (ScopePassingSpanSubscriber)sub;
                if (scopePassing.parent.equals(parent)) {
                    return sub;
                }
            }
            context = ReactorSleuth.contextWithBeans(context, lazyTracer, lazyCurrentTraceContext);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Spring context [" + springContext + "], Reactor context [" + context + "], name [" + ReactorSleuth.name(sub) + "]"));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating a scope passing span subscriber with Reactor Context [" + context + "] and name [" + ReactorSleuth.name(sub) + "]"));
            }
            return new ScopePassingSpanSubscriber(sub, context, currentTraceContext, parent);
        };
    }

    private static <T> Context contextWithBeans(Context context, LazyBean<Tracer> tracer, LazyBean<CurrentTraceContext> currentTraceContext) {
        if (!context.hasKey(Tracer.class)) {
            context = context.put(Tracer.class, (Object)tracer.getOrError());
        }
        if (!context.hasKey(CurrentTraceContext.class)) {
            context = context.put(CurrentTraceContext.class, (Object)currentTraceContext.getOrError());
        }
        return context;
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> springContextSpanOperator(ConfigurableApplicationContext springContext) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Spring Context passing operator [" + springContext + "]"));
        }
        LazyBean<Tracer> lazyTracer = LazyBean.create(springContext, Tracer.class);
        LazyBean<CurrentTraceContext> lazyCurrentTraceContext = LazyBean.create(springContext, CurrentTraceContext.class);
        return Operators.liftPublisher(p -> !(p instanceof Fuseable.ScalarCallable) && springContext.isActive(), (p, sub) -> {
            Context ctxBefore = ReactorSleuth.context(sub);
            Context context = ReactorSleuth.contextWithBeans(ctxBefore, lazyTracer, lazyCurrentTraceContext);
            if (context == ctxBefore) {
                return sub;
            }
            return new SleuthContextOperator(context, sub);
        });
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> onLastOperatorForOnEachInstrumentation(ConfigurableApplicationContext springContext) {
        LazyBean<CurrentTraceContext> lazyCurrentTraceContext = LazyBean.create(springContext, CurrentTraceContext.class);
        LazyBean<Tracer> lazyTracer = LazyBean.create(springContext, Tracer.class);
        BiFunction scopePassingSpanSubscriber = ReactorSleuth.liftFunction(springContext, lazyCurrentTraceContext, lazyTracer);
        BiFunction<Publisher, CoreSubscriber, CoreSubscriber> skipIfNoTraceCtx = (pub, sub) -> {
            TraceContext traceContext = ((CurrentTraceContext)lazyCurrentTraceContext.get()).context();
            if (ReactorSleuth.context(sub).getOrDefault(TraceContext.class, null) == traceContext) {
                return sub;
            }
            return (CoreSubscriber)scopePassingSpanSubscriber.apply((Publisher)pub, (CoreSubscriber)sub);
        };
        return ReactorHooksHelper.liftPublisher(p -> {
            CurrentTraceContext currentTraceContext;
            boolean addContext;
            if (ReactorHooksHelper.isTraceContextPropagator(p)) {
                return false;
            }
            boolean bl = addContext = !(p instanceof Fuseable.ScalarCallable) && springContext.isActive();
            if (addContext && (currentTraceContext = (CurrentTraceContext)lazyCurrentTraceContext.get()) != null) {
                addContext = currentTraceContext.context() != null;
            }
            return addContext;
        }, skipIfNoTraceCtx);
    }

    private static <T> Context context(CoreSubscriber<? super T> sub) {
        try {
            return sub.currentContext();
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception occurred while trying to retrieve the context", (Throwable)ex);
            }
            return Context.empty();
        }
    }

    static String name(CoreSubscriber<?> sub) {
        return Scannable.from(sub).name();
    }

    static TraceContext traceContext(Context context, CurrentTraceContext fallback) {
        if (context.hasKey(TraceContext.class)) {
            return (TraceContext)context.get(TraceContext.class);
        }
        return fallback.context();
    }

    public static Function<Runnable, Runnable> scopePassingOnScheduleHook(ConfigurableApplicationContext springContext) {
        LazyBean<CurrentTraceContext> lazyCurrentTraceContext = LazyBean.create(springContext, CurrentTraceContext.class);
        return delegate -> {
            if (springContext.isActive()) {
                CurrentTraceContext currentTraceContext = (CurrentTraceContext)lazyCurrentTraceContext.get();
                if (currentTraceContext == null) {
                    return delegate;
                }
                TraceContext traceContext = currentTraceContext.context();
                return () -> {
                    try (CurrentTraceContext.Scope scope = currentTraceContext.maybeScope(traceContext);){
                        delegate.run();
                    }
                };
            }
            return delegate;
        };
    }
}

