/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.jdbc;

import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.EventValue;
import org.springframework.cloud.sleuth.docs.TagKey;

enum SleuthJdbcSpan implements DocumentedSpan
{
    JDBC_QUERY_SPAN{

        public String getName() {
            return "%s";
        }

        public TagKey[] getTagKeys() {
            return QueryTags.values();
        }

        public EventValue[] getEvents() {
            return QueryEvents.values();
        }

        public String prefix() {
            return "jdbc.";
        }
    }
    ,
    JDBC_RESULT_SET_SPAN{

        public String getName() {
            return "result-set";
        }

        public TagKey[] getTagKeys() {
            return QueryTags.values();
        }

        public EventValue[] getEvents() {
            return QueryEvents.values();
        }

        public String prefix() {
            return "jdbc.";
        }
    }
    ,
    JDBC_CONNECTION_SPAN{

        public String getName() {
            return "connection";
        }

        public TagKey[] getTagKeys() {
            return ConnectionTags.values();
        }

        public String prefix() {
            return "jdbc.";
        }
    };


    static enum QueryEvents implements EventValue
    {
        COMMIT{

            public String getValue() {
                return "jdbc.commit";
            }
        }
        ,
        ROLLBACK{

            public String getValue() {
                return "jdbc.rollback";
            }
        };

    }

    static enum QueryTags implements TagKey
    {
        QUERY{

            public String getKey() {
                return "jdbc.query";
            }
        }
        ,
        ROW_COUNT{

            public String getKey() {
                return "jdbc.row-count";
            }
        };

    }

    static enum ConnectionTags implements TagKey
    {
        DATASOURCE_DRIVER{

            public String getKey() {
                return "jdbc.datasource.driver";
            }
        }
        ,
        DATASOURCE_POOL{

            public String getKey() {
                return "jdbc.datasource.pool";
            }
        };

    }
}

