/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.kafka;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;

public class KafkaTracingCallback
implements Callback {
    private static final Log log = LogFactory.getLog(KafkaTracingCallback.class);
    private final Callback callback;
    private final Tracer tracer;
    private final Span span;

    public KafkaTracingCallback(Callback callback, Tracer tracer, Span span) {
        this.callback = callback;
        this.tracer = tracer;
        this.span = span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompletion(RecordMetadata recordMetadata, Exception e) {
        try (Tracer.SpanInScope spanInScope = this.tracer.withSpan(this.span);){
            if (this.callback != null) {
                this.callback.onCompletion(recordMetadata, e);
            }
        }
        finally {
            if (e != null) {
                this.span.error((Throwable)e);
            }
            this.span.end();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished producer span " + this.span));
            }
        }
    }
}

