/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.otel.actuate;

import io.opentelemetry.exporter.internal.otlp.traces.ResourceSpansMarshaler;
import io.opentelemetry.proto.trace.v1.ResourceSpans;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.sleuth.autoconfig.actuate.FinishedSpanWriter;
import org.springframework.cloud.sleuth.autoconfig.actuate.TextOutputFormat;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.otel.bridge.OtelFinishedSpan;

class OtelOtlpFinishedSpanWriter
implements FinishedSpanWriter<byte[]> {
    OtelOtlpFinishedSpanWriter() {
    }

    public byte[] write(TextOutputFormat format, List<FinishedSpan> spans) {
        if (format == TextOutputFormat.CONTENT_TYPE_OTLP_PROTOBUF) {
            List<SpanData> spanData = spans.stream().map(OtelFinishedSpan::toOtel).collect(Collectors.toList());
            List<ResourceSpans> resourceSpans = this.toProtoResourceSpans(spanData);
            if (resourceSpans.isEmpty()) {
                return null;
            }
            ResourceSpans resources = resourceSpans.get(0);
            return resources.toByteArray();
        }
        return null;
    }

    private List<ResourceSpans> toProtoResourceSpans(List<SpanData> spanData) {
        return Arrays.stream(ResourceSpansMarshaler.create(spanData)).map(this::toResourceSpans).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResourceSpans toResourceSpans(ResourceSpansMarshaler resourceSpansMarshaler) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            resourceSpansMarshaler.writeBinaryTo((OutputStream)os);
            ResourceSpans resourceSpans = ResourceSpans.parseFrom((byte[])os.toByteArray());
            return resourceSpans;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

