/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.otel.actuate;

import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.sleuth.autoconfig.actuate.FinishedSpanWriter;
import org.springframework.cloud.sleuth.autoconfig.actuate.TextOutputFormat;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.otel.bridge.OtelFinishedSpan;
import zipkin2.Call;
import zipkin2.codec.Encoding;
import zipkin2.reporter.Sender;

class OtelZipkinFinishedSpanWriter
implements FinishedSpanWriter<String> {
    OtelZipkinFinishedSpanWriter() {
    }

    public String write(TextOutputFormat format, List<FinishedSpan> spans) {
        if (format == TextOutputFormat.CONTENT_TYPE_OPENZIPKIN_JSON_V2) {
            List spanData = spans.stream().map(OtelFinishedSpan::toOtel).collect(Collectors.toList());
            ArraySender arraySender = new ArraySender();
            ZipkinSpanExporter exporter = ZipkinSpanExporter.builder().setSender((Sender)arraySender).build();
            exporter.export(spanData);
            return arraySender.convertedJson;
        }
        return null;
    }

    static class ArraySender
    extends Sender {
        String convertedJson;

        ArraySender() {
        }

        public Encoding encoding() {
            return Encoding.JSON;
        }

        public int messageMaxBytes() {
            return 0;
        }

        public int messageSizeInBytes(List<byte[]> encodedSpans) {
            return 0;
        }

        public Call<Void> sendSpans(List<byte[]> encodedSpans) {
            this.convertedJson = '[' + encodedSpans.stream().map(String::new).collect(Collectors.joining(",")) + ']';
            return Call.create(null);
        }
    }
}

