/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.otel.actuate;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.Producible;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.autoconfig.actuate.FinishedSpanWriter;
import org.springframework.cloud.sleuth.autoconfig.actuate.TextOutputFormat;
import org.springframework.cloud.sleuth.autoconfig.actuate.TracesScrapeEndpoint;
import org.springframework.cloud.sleuth.autoconfig.brave.BraveAutoConfiguration;
import org.springframework.cloud.sleuth.autoconfig.otel.ConditionalOnOtelEnabled;
import org.springframework.cloud.sleuth.autoconfig.otel.actuate.OtelOtlpFinishedSpanWriter;
import org.springframework.cloud.sleuth.autoconfig.otel.actuate.OtelZipkinFinishedSpanWriter;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@ConditionalOnAvailableEndpoint(endpoint=TracesScrapeEndpoint.class)
@AutoConfigureBefore(value={BraveAutoConfiguration.class})
@ConditionalOnOtelEnabled
@ConditionalOnClass(value={Producible.class})
public class TraceSleuthOtelActuatorAutoConfiguration {
    @Bean
    @ConditionalOnClass(name={"io.opentelemetry.exporter.zipkin.ZipkinSpanExporter"})
    Supplier<FinishedSpanWriter> sleuthZipkinOtelFinishedSpanWriter() {
        return OtelZipkinFinishedSpanWriter::new;
    }

    @Bean
    @ConditionalOnClass(name={"io.opentelemetry.exporter.internal.otlp.traces.ResourceSpansMarshaler"})
    Supplier<FinishedSpanWriter> sleuthOtlpOtelFinishedSpanWriter() {
        return OtelOtlpFinishedSpanWriter::new;
    }

    @Bean
    @ConditionalOnMissingBean
    FinishedSpanWriter<Object> compositeFinishedSpanWriter(ObjectProvider<List<Supplier<FinishedSpanWriter>>> writers) {
        return new CompositeFinishedSpanWriter((List)writers.getIfAvailable(ArrayList::new));
    }

    static class CompositeFinishedSpanWriter
    implements FinishedSpanWriter<Object> {
        private final List<FinishedSpanWriter> writers;

        CompositeFinishedSpanWriter(List<Supplier<FinishedSpanWriter>> writers) {
            this.writers = writers.stream().map(Supplier::get).collect(Collectors.toList());
        }

        public Object write(TextOutputFormat format, List<FinishedSpan> spans) {
            for (FinishedSpanWriter writer : this.writers) {
                Object writtenSpans = writer.write(format, spans);
                if (writtenSpans == null) continue;
                return writtenSpans;
            }
            return null;
        }
    }
}

