/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.otel;

import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"brave.Tracer"})
@ConditionalOnProperty(value={"spring.sleuth.enabled", "spring.sleuth.otel.multiple-tracer-configs-detector-enabled"}, matchIfMissing=true)
class MultipleTracerAutoConfigurationsDetector {
    MultipleTracerAutoConfigurationsDetector() {
    }

    @PostConstruct
    void signalMultipleTracerAutoConfigurationsPresent() {
        throw new MultipleTracersFoundException();
    }

    static final class MultipleTracersFoundException
    extends RuntimeException {
        MultipleTracersFoundException() {
            super("You have both OpenTelemetry (OTel) and Brave (probably from Spring Cloud Sleuth Brave) tracers on the classpath. Please exclude <org.springframework.cloud:spring-cloud-sleuth-brave> dependency from <org.springframework.cloud:spring-cloud-starter-sleuth>. If the issue persist, please check the classpath, something brings in Brave that you need to exclude");
        }
    }
}

