/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BaggageTaggingSpanProcessor
implements SpanProcessor {
    private final Map<String, AttributeKey<String>> tagsToApply;

    public BaggageTaggingSpanProcessor(List<String> tagsToApply) {
        this.tagsToApply = tagsToApply.stream().map(tag -> AttributeKey.stringKey((String)tag)).collect(Collectors.toMap(AttributeKey::getKey, key -> key));
    }

    public void onStart(Context context, ReadWriteSpan readWriteSpan) {
        Baggage baggage = Baggage.fromContext((Context)context);
        baggage.forEach((key, baggageEntry) -> {
            AttributeKey<String> attributeKey = this.tagsToApply.get(key);
            if (attributeKey != null) {
                readWriteSpan.setAttribute(attributeKey, (Object)baggageEntry.getValue());
            }
        });
    }

    public boolean isStartRequired() {
        return true;
    }

    public void onEnd(ReadableSpan readableSpan) {
    }

    public boolean isEndRequired() {
        return false;
    }
}

