/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.sleuth.BaggageInScope;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.otel.bridge.Entry;
import org.springframework.cloud.sleuth.otel.bridge.OtelBaggageManager;
import org.springframework.cloud.sleuth.otel.bridge.OtelTraceContext;

class OtelBaggageInScope
implements BaggageInScope {
    private final OtelBaggageManager otelBaggageManager;
    private final CurrentTraceContext currentTraceContext;
    private final List<String> tagFields;
    private final AtomicReference<Entry> entry = new AtomicReference();
    private final AtomicReference<Scope> scope = new AtomicReference();

    OtelBaggageInScope(OtelBaggageManager otelBaggageManager, CurrentTraceContext currentTraceContext, List<String> tagFields, Entry entry) {
        this.otelBaggageManager = otelBaggageManager;
        this.currentTraceContext = currentTraceContext;
        this.tagFields = tagFields;
        this.entry.set(entry);
    }

    public String name() {
        return this.entry().getKey();
    }

    public String get() {
        return this.otelBaggageManager.currentBaggage().getEntryValue(this.entry().getKey());
    }

    public String get(TraceContext traceContext) {
        Entry entry = this.otelBaggageManager.getEntry((OtelTraceContext)traceContext, this.entry().getKey());
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public BaggageInScope set(String value) {
        return this.doSet(this.currentTraceContext.context(), value);
    }

    private BaggageInScope doSet(TraceContext context, String value) {
        Baggage baggage;
        Context current = Context.current();
        Span currentSpan = Span.current();
        if (context != null) {
            OtelTraceContext ctx = (OtelTraceContext)context;
            Context storedCtx = ctx.context();
            Baggage fromContext = Baggage.fromContext((Context)storedCtx);
            BaggageBuilder newBaggageBuilder = fromContext.toBuilder();
            Baggage.current().forEach((key, baggageEntry) -> newBaggageBuilder.put(key, baggageEntry.getValue(), baggageEntry.getMetadata()));
            baggage = newBaggageBuilder.put(this.entry().getKey(), value, this.entry().getMetadata()).build();
            current = current.with((ImplicitContextKeyed)baggage);
            ctx.updateContext(current);
        } else {
            baggage = Baggage.builder().put(this.entry().getKey(), value, this.entry().getMetadata()).build();
        }
        Context withBaggage = current.with((ImplicitContextKeyed)baggage);
        this.scope.set(withBaggage.makeCurrent());
        if (this.tagFields.stream().map(String::toLowerCase).anyMatch(s -> s.equals(this.entry().getKey()))) {
            currentSpan.setAttribute(this.entry().getKey(), value);
        }
        Entry previous = this.entry();
        this.entry.set(new Entry(previous.getKey(), value, previous.getMetadata()));
        return this;
    }

    private Entry entry() {
        return this.entry.get();
    }

    public BaggageInScope set(TraceContext traceContext, String value) {
        return this.doSet(traceContext, value);
    }

    public BaggageInScope makeCurrent() {
        this.close();
        Entry entry = this.entry();
        Scope scope = Baggage.builder().put(entry.getKey(), entry.getValue(), entry.getMetadata()).build().makeCurrent();
        this.scope.set(scope);
        return this;
    }

    public void close() {
        Scope scope = this.scope.get();
        if (scope != null) {
            this.scope.set(null);
            scope.close();
        }
    }
}

