/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import org.springframework.cloud.sleuth.http.HttpRequest;
import org.springframework.cloud.sleuth.http.HttpResponse;
import org.springframework.util.StringUtils;

class PathAttributeExtractor
implements AttributesExtractor<HttpRequest, HttpResponse> {
    private static final AttributeKey<String> HTTP_PATH = AttributeKey.stringKey((String)"http.path");

    PathAttributeExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, HttpRequest httpRequest) {
        String path = httpRequest.path();
        if (StringUtils.hasLength((String)path)) {
            attributes.put(SemanticAttributes.HTTP_ROUTE, (Object)path);
            attributes.put(HTTP_PATH, (Object)path);
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, HttpRequest httpRequest, HttpResponse httpResponse, Throwable error) {
    }
}

