/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import java.util.regex.Pattern;
import org.springframework.cloud.sleuth.SamplerFunction;
import org.springframework.cloud.sleuth.http.HttpRequest;

public class SkipPatternSampler
implements SamplerFunction<HttpRequest> {
    private final Pattern pattern;

    public SkipPatternSampler(Pattern pattern) {
        this.pattern = pattern;
    }

    public final Boolean trySample(HttpRequest request) {
        String url = request.path();
        boolean shouldSkip = this.pattern.matcher(url).matches();
        if (shouldSkip) {
            return false;
        }
        return null;
    }
}

