/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class Entry
implements BaggageEntry {
    final String key;
    final String value;
    final BaggageEntryMetadata entryMetadata;

    Entry(String key, String value, BaggageEntryMetadata entryMetadata) {
        this.key = key;
        this.value = value;
        this.entryMetadata = entryMetadata;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public BaggageEntryMetadata getMetadata() {
        return this.entryMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entry entry = (Entry)o;
        return Objects.equals(this.key, entry.key) && Objects.equals(this.value, entry.value) && Objects.equals(this.entryMetadata, entry.entryMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.entryMetadata);
    }

    static List<Entry> fromBaggage(Baggage baggage) {
        ArrayList<Entry> list = new ArrayList<Entry>(baggage.size());
        baggage.forEach((key, value) -> list.add(new Entry((String)key, value.getValue(), value.getMetadata())));
        return list;
    }
}

