/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.otel.bridge;

import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.otel.bridge.OtelTraceContext;
import org.springframework.cloud.sleuth.otel.bridge.SpanFromSpanContext;

class OtelSpan
implements Span {
    final io.opentelemetry.api.trace.Span delegate;
    private final AtomicReference<Context> context;

    OtelSpan(io.opentelemetry.api.trace.Span delegate) {
        this.delegate = delegate;
        if (delegate instanceof SpanFromSpanContext) {
            SpanFromSpanContext fromSpanContext = (SpanFromSpanContext)delegate;
            this.context = fromSpanContext.otelTraceContext.context;
        } else {
            this.context = new AtomicReference<Context>(Context.current());
        }
    }

    OtelSpan(io.opentelemetry.api.trace.Span delegate, Context context) {
        this.delegate = delegate;
        this.context = new AtomicReference<Context>(context);
    }

    static io.opentelemetry.api.trace.Span toOtel(Span span) {
        return ((OtelSpan)AssertingSpan.unwrap((Span)span)).delegate;
    }

    static Span fromOtel(io.opentelemetry.api.trace.Span span) {
        return new OtelSpan(span);
    }

    static Span fromOtel(io.opentelemetry.api.trace.Span span, Context context) {
        return new OtelSpan(span, context);
    }

    public boolean isNoop() {
        return !this.delegate.isRecording();
    }

    public OtelTraceContext context() {
        if (this.delegate == null) {
            return null;
        }
        return new OtelTraceContext(this.context, this.delegate.getSpanContext(), this.delegate);
    }

    public Span start() {
        return this;
    }

    public Span name(String name) {
        this.delegate.updateName(name);
        return new OtelSpan(this.delegate);
    }

    public Span event(String value) {
        this.delegate.addEvent(value);
        return new OtelSpan(this.delegate);
    }

    public Span tag(String key, String value) {
        this.delegate.setAttribute(key, value);
        return new OtelSpan(this.delegate);
    }

    public Span error(Throwable throwable) {
        this.delegate.recordException(throwable);
        this.delegate.setStatus(StatusCode.ERROR, throwable.getMessage());
        return new OtelSpan(this.delegate);
    }

    public void end() {
        this.delegate.end();
    }

    public Span remoteIpAndPort(String ip, int port) {
        this.delegate.setAttribute(SemanticAttributes.NET_SOCK_PEER_ADDR, (Object)ip);
        this.delegate.setAttribute(SemanticAttributes.NET_PEER_PORT, (Object)port);
        return this;
    }

    public void abandon() {
    }

    public Span remoteServiceName(String remoteServiceName) {
        this.delegate.setAttribute("peer.service", remoteServiceName);
        return this;
    }

    public String toString() {
        return this.delegate != null ? this.delegate.toString() : "null";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Object unwrapped = o;
        if (o instanceof AssertingSpan) {
            unwrapped = ((AssertingSpan)o).getDelegate();
        }
        if (unwrapped == null || this.getClass() != unwrapped.getClass()) {
            return false;
        }
        OtelSpan otelSpan = (OtelSpan)unwrapped;
        return Objects.equals(this.delegate, otelSpan.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }
}

