/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.sleuth.instrument.web.client.TraceResponseHttpHeadersFilter;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

public abstract class TraceResponseHttpHeadersFilterTests
implements TestTracingAwareSupplier {
    @Test
    public void should_not_report_span_when_no_span_was_present_in_attribute() {
        TraceResponseHttpHeadersFilter filter = new TraceResponseHttpHeadersFilter(this.tracerTest().tracing().tracer(), this.tracerTest().tracing().httpClientHandler(), this.tracerTest().tracing().propagator());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("b3", "52f112af7472aff0-53e6ab6fc5dfee58");
        MockServerHttpRequest request = ((MockServerHttpRequest.BodyBuilder)MockServerHttpRequest.post((String)"foo/bar", (Object[])new Object[0]).headers((MultiValueMap)httpHeaders)).build();
        MockServerWebExchange exchange = MockServerWebExchange.builder((MockServerHttpRequest)request).build();
        filter.filter(httpHeaders, (ServerWebExchange)exchange);
        BDDAssertions.then(this.tracerTest().handler().reportedSpans()).isEmpty();
    }

    @Test
    public void should_report_span_when_span_was_present_in_attribute() {
        TraceResponseHttpHeadersFilter filter = new TraceResponseHttpHeadersFilter(this.tracerTest().tracing().tracer(), this.tracerTest().tracing().httpClientHandler(), this.tracerTest().tracing().propagator());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("b3", "52f112af7472aff0-53e6ab6fc5dfee58");
        MockServerHttpRequest request = ((MockServerHttpRequest.BodyBuilder)MockServerHttpRequest.post((String)"foo/bar", (Object[])new Object[0]).headers((MultiValueMap)httpHeaders)).build();
        MockServerWebExchange exchange = MockServerWebExchange.builder((MockServerHttpRequest)request).build();
        exchange.getAttributes().put(TraceResponseHttpHeadersFilter.SPAN_ATTRIBUTE, this.tracerTest().tracing().tracer().nextSpan());
        filter.filter(httpHeaders, (ServerWebExchange)exchange);
        BDDAssertions.then(this.tracerTest().handler().reportedSpans()).isNotEmpty();
    }
}

